/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class EntityImageSynchroBar
extends AbstractEntityImage {
    public EntityImageSynchroBar(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.getSkinParam().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            return new Dimension2DDouble(8.0, 80.0);
        }
        return new Dimension2DDouble(80.0, 8.0);
    }

    public final void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.apply(new UChangeColor(null)).apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBar, this.getStereo()))).draw(uRectangle);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

