/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private final TextBlockBackcolored graphicStrings;
    private final BufferedImage flashCode;
    private final String text;

    public GraphvizCrash(String string) {
        this.text = string;
        FlashCodeUtils flashCodeUtils = FlashCodeFactory.getFlashCodeUtils();
        this.flashCode = flashCodeUtils.exportFlashcode(string);
        this.graphicStrings = GraphicStrings.createBlackOnWhite(this.init(), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    public static List<String> anErrorHasOccured(Throwable throwable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (throwable == null) {
            arrayList.add("An error has occured!");
        } else {
            arrayList.add("An error has occured : " + throwable);
        }
        String string2 = StringUtils.rot(QuoteUtils.getSomeQuote());
        arrayList.add("<i>" + string2);
        arrayList.add(" ");
        arrayList.add("Diagram size: " + GraphvizCrash.lines(string) + " lines / " + string.length() + " characters.");
        arrayList.add(" ");
        return arrayList;
    }

    private static int lines(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public static void checkOldVersionWarning(List<String> list) {
        long l = (System.currentTimeMillis() - Version.compileTime()) / 1000L / 3600L / 24L;
        if (l >= 90L) {
            list.add("This version of PlantUML is " + l + " days old, so you should");
            list.add("  consider upgrading from http://plantuml.com/download");
        }
    }

    public static void pleaseGoTo(List<String> list) {
        list.add(" ");
        list.add("Please go to http://plantuml.com/graphviz-dot to check your GraphViz version.");
        list.add(" ");
    }

    public static void youShouldSendThisDiagram(List<String> list) {
        list.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        list.add("post to <b>http://plantuml.com/qa</b> to solve this issue.");
        list.add("You can try to turn arround this issue by simplifing your diagram.");
    }

    public static void thisMayBeCaused(List<String> list) {
        list.add("This may be caused by :");
        list.add(" - a bug in PlantUML");
        list.add(" - a problem in GraphViz");
    }

    private List<String> init() {
        List<String> list = GraphvizCrash.anErrorHasOccured(null, this.text);
        list.add("For some reason, dot/Graphviz has crashed.");
        list.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        GraphvizCrash.checkOldVersionWarning(list);
        list.add(" ");
        GraphvizCrash.addProperties(list);
        list.add(" ");
        try {
            String string = GraphvizUtils.dotVersion();
            list.add("Default dot version: " + string);
        }
        catch (Throwable throwable) {
            list.add("Cannot determine dot version: " + throwable.toString());
        }
        GraphvizCrash.pleaseGoTo(list);
        GraphvizCrash.youShouldSendThisDiagram(list);
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(list);
        }
        return list;
    }

    public static void addDecodeHint(List<String> list) {
        list.add(" ");
        list.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the flashcode)");
    }

    public static void addProperties(List<String> list) {
        list.addAll(OptionPrint.interestingProperties());
        list.addAll(OptionPrint.interestingValues());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HtmlColor getBackcolor() {
        return HtmlColorUtils.WHITE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.graphicStrings.calculateDimension(stringBounder);
        if (this.flashCode != null) {
            dimension2D = Dimension2DDouble.mergeTB(dimension2D, new Dimension2DDouble(this.flashCode.getWidth(), this.flashCode.getHeight()));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.graphicStrings.drawU(uGraphic);
        if (this.flashCode != null) {
            double d = this.graphicStrings.calculateDimension(uGraphic.getStringBounder()).getHeight();
            uGraphic = uGraphic.apply(new UTranslate(0.0, d));
            uGraphic.draw(new UImage(this.flashCode));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }
}

