/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DecorateEntityImage
extends AbstractTextBlock
implements TextBlockBackcolored {
    private final TextBlock original;
    private final HorizontalAlignment horizontal1;
    private final TextBlock text1;
    private final HorizontalAlignment horizontal2;
    private final TextBlock text2;
    private double deltaX;
    private double deltaY;

    public static DecorateEntityImage addTop(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new DecorateEntityImage(textBlock, textBlock2, horizontalAlignment, null, null);
    }

    public static DecorateEntityImage addBottom(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new DecorateEntityImage(textBlock, null, null, textBlock2, horizontalAlignment);
    }

    public static DecorateEntityImage add(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        if (verticalAlignment == VerticalAlignment.TOP) {
            return DecorateEntityImage.addTop(textBlock, textBlock2, horizontalAlignment);
        }
        return DecorateEntityImage.addBottom(textBlock, textBlock2, horizontalAlignment);
    }

    public DecorateEntityImage(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment, TextBlock textBlock3, HorizontalAlignment horizontalAlignment2) {
        this.original = textBlock;
        this.horizontal1 = horizontalAlignment;
        this.text1 = textBlock2;
        this.horizontal2 = horizontalAlignment2;
        this.text2 = textBlock3;
    }

    public void drawU(UGraphic uGraphic) {
        double d;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.original.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getTextDim(this.text1, stringBounder);
        Dimension2D dimension2D3 = this.getTextDim(this.text2, stringBounder);
        Dimension2D dimension2D4 = this.calculateDimension(stringBounder);
        double d2 = dimension2D2.getHeight();
        double d3 = d2 + dimension2D.getHeight();
        double d4 = (dimension2D4.getWidth() - dimension2D.getWidth()) / 2.0;
        if (this.text1 != null) {
            d = this.getTextX(dimension2D2, dimension2D4, this.horizontal1);
            this.text1.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
        }
        this.original.drawU(uGraphic.apply(new UTranslate(d4, d2)));
        this.deltaX = d4;
        this.deltaY = d2;
        if (this.text2 != null) {
            d = this.getTextX(dimension2D3, dimension2D4, this.horizontal2);
            this.text2.drawU(uGraphic.apply(new UTranslate(d, d3)));
        }
    }

    private Dimension2D getTextDim(TextBlock textBlock, StringBounder stringBounder) {
        if (textBlock == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return textBlock.calculateDimension(stringBounder);
    }

    private double getTextX(Dimension2D dimension2D, Dimension2D dimension2D2, HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            return (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
        }
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            return dimension2D2.getWidth() - dimension2D.getWidth();
        }
        throw new IllegalStateException();
    }

    public HtmlColor getBackcolor() {
        if (this.original instanceof TextBlockBackcolored) {
            return ((TextBlockBackcolored)this.original).getBackcolor();
        }
        throw new UnsupportedOperationException();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.original.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = Dimension2DDouble.mergeTB(this.getTextDim(this.text1, stringBounder), this.getTextDim(this.text2, stringBounder));
        return Dimension2DDouble.mergeTB(dimension2D, dimension2D2);
    }

    public final double getDeltaX() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaX + ((DecorateEntityImage)this.original).deltaX;
        }
        return this.deltaX;
    }

    public final double getDeltaY() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaY + ((DecorateEntityImage)this.original).deltaY;
        }
        return this.deltaY;
    }
}

