/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.directdot.PSystemDot;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;
import net.sourceforge.plantuml.eggs.PSystemWelcome;
import net.sourceforge.plantuml.jcckit.PSystemJcckit;
import net.sourceforge.plantuml.math.PSystemMath;
import net.sourceforge.plantuml.salt.PSystemSalt;
import net.sourceforge.plantuml.stats.FormatCounter;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.stats.StatsUtils;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.sudoku.PSystemSudoku;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsUtilsIncrement {
    private static final Preferences prefs = StatsUtils.prefs;
    private static final ConcurrentMap<String, ParsedGenerated> byTypeEver = StatsUtils.byTypeEver;
    private static final ConcurrentMap<String, ParsedGenerated> byTypeCurrent = StatsUtils.byTypeCurrent;
    private static final FormatCounter formatCounterCurrent = StatsUtils.formatCounterCurrent;
    private static final FormatCounter formatCounterEver = StatsUtils.formatCounterEver;
    private static final Lock lockXml = new ReentrantLock();
    private static final Lock lockHtml = new ReentrantLock();

    public static void onceMoreParse(long l, Class<? extends Diagram> clazz) {
        StatsUtilsIncrement.getByTypeCurrent(clazz).parsed().addValue(l);
        ParsedGenerated parsedGenerated = StatsUtilsIncrement.getByTypeEver(clazz);
        parsedGenerated.parsed().addValue(l);
        StatsUtils.fullEver.parsed().addValue(l);
        StatsUtils.historicalData.current().parsed().addValue(l);
        StatsUtils.historicalData.current().parsed().save(prefs);
        StatsUtils.fullEver.parsed().save(prefs);
        parsedGenerated.parsed().save(prefs);
        StatsUtilsIncrement.realTimeExport();
    }

    public static void onceMoreGenerate(long l, Class<? extends Diagram> clazz, FileFormat fileFormat) {
        StatsUtilsIncrement.getByTypeCurrent(clazz).generated().addValue(l);
        ParsedGenerated parsedGenerated = StatsUtilsIncrement.getByTypeEver(clazz);
        parsedGenerated.generated().addValue(l);
        StatsUtils.fullEver.generated().addValue(l);
        StatsUtils.historicalData.current().generated().addValue(l);
        formatCounterCurrent.plusOne(fileFormat, l);
        formatCounterEver.plusOne(fileFormat, l);
        formatCounterEver.save(prefs, fileFormat);
        StatsUtils.historicalData.current().generated().save(prefs);
        StatsUtils.fullEver.generated().save(prefs);
        parsedGenerated.generated().save(prefs);
        StatsUtilsIncrement.realTimeExport();
    }

    private static ParsedGenerated getByTypeCurrent(Class<? extends Diagram> clazz) {
        String string = StatsUtilsIncrement.name(clazz);
        ParsedGenerated parsedGenerated = (ParsedGenerated)byTypeCurrent.get(string);
        if (parsedGenerated == null) {
            byTypeCurrent.putIfAbsent(string, ParsedGenerated.createVolatileDated());
            parsedGenerated = (ParsedGenerated)byTypeCurrent.get(string);
        }
        return parsedGenerated;
    }

    private static ParsedGenerated getByTypeEver(Class<? extends Diagram> clazz) {
        String string = StatsUtilsIncrement.name(clazz);
        ParsedGenerated parsedGenerated = (ParsedGenerated)byTypeEver.get(string);
        if (parsedGenerated == null) {
            byTypeEver.putIfAbsent(string, ParsedGenerated.loadDated(prefs, "type." + string));
            parsedGenerated = (ParsedGenerated)byTypeEver.get(string);
        }
        return parsedGenerated;
    }

    private static String name(Class<? extends Diagram> clazz) {
        if (clazz == PSystemError.class) {
            return "Error";
        }
        if (clazz == ActivityDiagram3.class) {
            return "ActivityDiagramBeta";
        }
        if (clazz == PSystemSalt.class) {
            return "Salt";
        }
        if (clazz == PSystemSudoku.class) {
            return "Sudoku";
        }
        if (clazz == PSystemDot.class) {
            return "Dot";
        }
        if (clazz == PSystemWelcome.class) {
            return "Welcome";
        }
        if (clazz == PSystemDitaa.class) {
            return "Ditaa";
        }
        if (clazz == PSystemJcckit.class) {
            return "Jcckit";
        }
        if (clazz == PSystemMath.class) {
            return "Math";
        }
        String string = clazz.getSimpleName();
        if (string.endsWith("Diagram")) {
            return string;
        }
        return "Other";
    }

    private static void realTimeExport() {
        block11: {
            if (StatsUtils.realTimeStats) {
                Stats stats = StatsUtils.getStatsLazzy();
                try {
                    if (StatsUtils.xmlStats && lockXml.tryLock()) {
                        try {
                            StatsUtils.xmlOutput(stats);
                        }
                        finally {
                            lockXml.unlock();
                        }
                    }
                    if (!StatsUtils.htmlStats || !lockHtml.tryLock()) break block11;
                    try {
                        StatsUtils.htmlOutput(stats);
                    }
                    finally {
                        lockHtml.unlock();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

