/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsTableImpl
implements StatsTable {
    private final String name;
    private final Collection<StatsColumn> columnHeaders;
    private final List<StatsLine> lines = new ArrayList<StatsLine>();

    public StatsTableImpl(String string) {
        this.name = string;
        this.columnHeaders = EnumSet.noneOf(StatsColumn.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<StatsColumn> getColumnHeaders() {
        return Collections.unmodifiableCollection(this.columnHeaders);
    }

    @Override
    public List<StatsLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public void addLine(StatsLine statsLine) {
        this.columnHeaders.addAll(statsLine.getColumnHeaders());
        this.lines.add(statsLine);
    }
}

