/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.plantuml.api.NumberAnalyzed;
import net.sourceforge.plantuml.stats.FormatCounter;
import net.sourceforge.plantuml.stats.HistoricalData;
import net.sourceforge.plantuml.stats.HumanDuration;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.stats.StatsLineImpl;
import net.sourceforge.plantuml.stats.StatsTableImpl;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsImpl
implements Stats {
    private final FormatCounter formatCounterCurrent;
    private final FormatCounter formatCounterEver;
    private final Map<String, ParsedGenerated> byTypeEver;
    private final Map<String, ParsedGenerated> byTypeCurrent;
    private final ParsedGenerated fullEver;
    private final HistoricalData historicalData;

    StatsImpl(Map<String, ParsedGenerated> map, Map<String, ParsedGenerated> map2, FormatCounter formatCounter, FormatCounter formatCounter2, HistoricalData historicalData, ParsedGenerated parsedGenerated) {
        this.byTypeEver = map;
        this.byTypeCurrent = map2;
        this.formatCounterCurrent = formatCounter;
        this.formatCounterEver = formatCounter2;
        this.fullEver = parsedGenerated;
        this.historicalData = historicalData;
    }

    private StatsLine createDataLineSession(ParsedGenerated parsedGenerated) {
        EnumMap<StatsColumn, Object> enumMap = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        long l = parsedGenerated.getId();
        if (l != -1L) {
            enumMap.put(StatsColumn.SESSION_ID, Long.valueOf(l));
        }
        enumMap.put(StatsColumn.VERSION, parsedGenerated.getVersion());
        long l2 = parsedGenerated.parsedDated().getCreationTime();
        long l3 = parsedGenerated.parsedDated().getModificationTime();
        enumMap.put(StatsColumn.STARTING, new Date(l2));
        enumMap.put(StatsColumn.LAST, new Date(l3));
        enumMap.put(StatsColumn.DURATION_STRING, new HumanDuration(l3 - l2));
        enumMap.put(StatsColumn.PARSED_COUNT, Long.valueOf(parsedGenerated.parsedDated().getNb()));
        enumMap.put(StatsColumn.PARSED_MEAN_TIME, Long.valueOf(parsedGenerated.parsedDated().getMean()));
        enumMap.put(StatsColumn.PARSED_STANDARD_DEVIATION, Long.valueOf(parsedGenerated.parsedDated().getStandardDeviation()));
        enumMap.put(StatsColumn.PARSED_MAX_TIME, Long.valueOf(parsedGenerated.parsedDated().getMax()));
        enumMap.put(StatsColumn.GENERATED_COUNT, Long.valueOf(parsedGenerated.generatedDated().getNb()));
        enumMap.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(parsedGenerated.generatedDated().getMean()));
        enumMap.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(parsedGenerated.generatedDated().getStandardDeviation()));
        enumMap.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(parsedGenerated.generatedDated().getMax()));
        return new StatsLineImpl(enumMap);
    }

    private StatsLine createLineByDiagramType(String string, NumberAnalyzed numberAnalyzed, NumberAnalyzed numberAnalyzed2) {
        EnumMap<StatsColumn, Object> enumMap = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        enumMap.put(StatsColumn.DIAGRAM_TYPE, string);
        enumMap.put(StatsColumn.PARSED_COUNT, Long.valueOf(numberAnalyzed.getNb()));
        enumMap.put(StatsColumn.PARSED_MEAN_TIME, Long.valueOf(numberAnalyzed.getMean()));
        enumMap.put(StatsColumn.PARSED_STANDARD_DEVIATION, Long.valueOf(numberAnalyzed.getStandardDeviation()));
        enumMap.put(StatsColumn.PARSED_MAX_TIME, Long.valueOf(numberAnalyzed.getMax()));
        enumMap.put(StatsColumn.GENERATED_COUNT, Long.valueOf(numberAnalyzed2.getNb()));
        enumMap.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(numberAnalyzed2.getMean()));
        enumMap.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(numberAnalyzed2.getStandardDeviation()));
        enumMap.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(numberAnalyzed2.getMax()));
        return new StatsLineImpl(enumMap);
    }

    @Override
    public StatsTable getLastSessions() {
        StatsTableImpl statsTableImpl = new StatsTableImpl("Statistics");
        for (ParsedGenerated parsedGenerated : this.historicalData.getHistorical()) {
            statsTableImpl.addLine(this.createDataLineSession(parsedGenerated));
        }
        if (this.historicalData.current() != null) {
            statsTableImpl.addLine(this.createDataLineSession(this.historicalData.current()));
        }
        statsTableImpl.addLine(this.createDataLineSession(this.fullEver));
        return statsTableImpl;
    }

    @Override
    public StatsTable getCurrentSessionByFormat() {
        return this.formatCounterCurrent.getStatsTable("current format");
    }

    @Override
    public StatsTable getAllByFormat() {
        return this.formatCounterEver.getStatsTable("all format");
    }

    @Override
    public StatsTable getCurrentSessionByDiagramType() {
        return this.getByDiagramType("Current session", this.byTypeCurrent);
    }

    @Override
    public StatsTable getAllByDiagramType() {
        return this.getByDiagramType("All session", this.byTypeEver);
    }

    private StatsTable getByDiagramType(String string, Map<String, ParsedGenerated> map) {
        StatsTableImpl statsTableImpl = new StatsTableImpl(string);
        TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
        NumberAnalyzed numberAnalyzed = new NumberAnalyzed();
        NumberAnalyzed numberAnalyzed2 = new NumberAnalyzed();
        for (String string2 : treeSet) {
            NumberAnalyzed numberAnalyzed3 = map.get(string2).parsed();
            NumberAnalyzed numberAnalyzed4 = map.get(string2).generated();
            numberAnalyzed.add(numberAnalyzed3);
            numberAnalyzed2.add(numberAnalyzed4);
            statsTableImpl.addLine(this.createLineByDiagramType(string2, numberAnalyzed3, numberAnalyzed4));
        }
        statsTableImpl.addLine(this.createLineByDiagramType("Total", numberAnalyzed, numberAnalyzed2));
        return statsTableImpl;
    }
}

