/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.prefs.Preferences;
import net.sourceforge.plantuml.api.NumberAnalyzed;
import net.sourceforge.plantuml.api.NumberAnalyzedDated;

public class ParsedGenerated {
    private final NumberAnalyzed parsed;
    private final NumberAnalyzed generated;

    private ParsedGenerated(NumberAnalyzed numberAnalyzed, NumberAnalyzed numberAnalyzed2) {
        if (numberAnalyzed == null || numberAnalyzed2 == null) {
            throw new IllegalArgumentException();
        }
        this.parsed = numberAnalyzed;
        this.generated = numberAnalyzed2;
    }

    public void reset() {
        this.parsed.reset();
        this.generated.reset();
    }

    public static ParsedGenerated createVolatile() {
        return new ParsedGenerated(new NumberAnalyzed(), new NumberAnalyzed());
    }

    public static ParsedGenerated createVolatileDated() {
        return new ParsedGenerated(new NumberAnalyzedDated(), new NumberAnalyzedDated());
    }

    public static ParsedGenerated loadDated(Preferences preferences, String string) {
        NumberAnalyzedDated numberAnalyzedDated;
        NumberAnalyzedDated numberAnalyzedDated2 = NumberAnalyzedDated.load(string + ".p", preferences);
        if (numberAnalyzedDated2 == null) {
            numberAnalyzedDated2 = new NumberAnalyzedDated(string + ".p");
        }
        if ((numberAnalyzedDated = NumberAnalyzedDated.load(string + ".g", preferences)) == null) {
            numberAnalyzedDated = new NumberAnalyzedDated(string + ".g");
        }
        return new ParsedGenerated(numberAnalyzedDated2, numberAnalyzedDated);
    }

    public NumberAnalyzed parsed() {
        return this.parsed;
    }

    public NumberAnalyzed generated() {
        return this.generated;
    }

    public NumberAnalyzedDated parsedDated() {
        return (NumberAnalyzedDated)this.parsed;
    }

    public NumberAnalyzedDated generatedDated() {
        return (NumberAnalyzedDated)this.generated;
    }

    public long getId() {
        String string = this.parsedDated().getComment();
        int n = string.indexOf(47);
        if (n == -1) {
            return -1L;
        }
        return Long.parseLong(string.substring(0, n), 36);
    }

    public String getVersion() {
        String string = this.parsedDated().getComment();
        int n = string.indexOf(47);
        if (n == -1) {
            return " ";
        }
        return string.substring(n + 1);
    }
}

