/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.stats.HumanDuration;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlConverter {
    private final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final Stats stats;

    public HtmlConverter(Stats stats) {
        this.stats = stats;
    }

    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<style type=\"text/css\">");
        stringBuilder.append("body { font-family: arial, helvetica, sans-serif; font-size: 12px; font-weight: normal; color: black; background: white;}");
        stringBuilder.append("th,td { font-size: 12px;}");
        stringBuilder.append("table { border-collapse: collapse; border-style: none;}");
        stringBuilder.append("</style>");
        stringBuilder.append("<h2>Statistics</h2>");
        this.printTableHtml(stringBuilder, this.stats.getLastSessions());
        StatsTable statsTable = this.stats.getCurrentSessionByDiagramType();
        if (statsTable.getLines().size() > 1) {
            stringBuilder.append("<h2>Current session statistics</h2>");
            this.printTableHtml(stringBuilder, statsTable);
            stringBuilder.append("<p>");
            this.printTableHtml(stringBuilder, this.stats.getCurrentSessionByFormat());
        }
        stringBuilder.append("<h2>General statistics since ever</h2>");
        this.printTableHtml(stringBuilder, this.stats.getAllByDiagramType());
        stringBuilder.append("<p>");
        this.printTableHtml(stringBuilder, this.stats.getAllByFormat());
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private void printTableHtml(StringBuilder stringBuilder, StatsTable statsTable) {
        Collection<StatsColumn> collection = statsTable.getColumnHeaders();
        stringBuilder.append("<table border=1 cellspacing=0 cellpadding=2>");
        stringBuilder.append(this.getHtmlHeader(collection));
        List<StatsLine> list = statsTable.getLines();
        for (int i = 0; i < list.size(); ++i) {
            StatsLine statsLine = list.get(i);
            boolean bl = i == list.size() - 1;
            stringBuilder.append(this.getCreoleLine(collection, statsLine, bl));
        }
        stringBuilder.append("</table>");
    }

    private String getCreoleLine(Collection<StatsColumn> collection, StatsLine statsLine, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<tr bgcolor=#f0f0f0>");
        } else {
            stringBuilder.append("<tr bgcolor=#fcfcfc>");
        }
        for (StatsColumn statsColumn : collection) {
            Object object = statsLine.getValue(statsColumn);
            if (object instanceof Long || object instanceof HumanDuration) {
                stringBuilder.append("<td align=right>");
            } else {
                stringBuilder.append("<td>");
            }
            if (bl) {
                stringBuilder.append("<b>");
            }
            if (object instanceof Long) {
                stringBuilder.append(String.format("%,d", object));
            } else if (object instanceof Date) {
                stringBuilder.append(this.formatter.format(object));
            } else if (object == null || object.toString().length() == 0) {
                stringBuilder.append(" ");
            } else {
                stringBuilder.append(object.toString());
            }
            if (bl) {
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>");
        return stringBuilder.toString();
    }

    private String getHtmlHeader(Collection<StatsColumn> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<tr bgcolor=#e0e0e0>");
        for (StatsColumn statsColumn : collection) {
            stringBuilder.append("<td><b>");
            stringBuilder.append(statsColumn.getTitle().replace("\\n", "<br>"));
            stringBuilder.append("</b></td>");
        }
        stringBuilder.append("</tr>");
        return stringBuilder.toString();
    }
}

