/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreatePackageState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreatePackageState() {
        super(CommandCreatePackageState.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^state[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)[%s]+"), new RegexLeaf("DISPLAY1", "as[%s]+[%g]([^%g]+)[%g]")), new RegexConcat(new RegexLeaf("DISPLAY2", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"))), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreatePackageState.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("(?:[%s]*\\{|[%s]+begin)$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private String getNotNull(RegexResult regexResult, String string, String string2) {
        if (regexResult.get(string, 0) == null) {
            return regexResult.get(string2, 0);
        }
        return regexResult.get(string, 0);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram stateDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        String string;
        IGroup iGroup = stateDiagram.getCurrentGroup();
        Code code = Code.of(this.getNotNull(regexResult, "CODE1", "CODE2"));
        String string2 = this.getNotNull(regexResult, "DISPLAY1", "DISPLAY2");
        if (string2 == null) {
            string2 = code.getFullName();
        }
        IGroup iGroup2 = stateDiagram.getOrCreateGroup(code, Display.getWithNewlines(string2), GroupType.STATE, iGroup);
        String string3 = regexResult.get("STEREOTYPE", 0);
        if (string3 != null) {
            iGroup2.setStereotype(new Stereotype(string3));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object2 = new UrlBuilder(stateDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = ((UrlBuilder)object2).getUrl(string);
            iGroup2.addUrl((Url)object);
        }
        object2 = CommandCreatePackageState.color().getColor(regexResult, stateDiagram.getSkinParam().getIHtmlColorSet());
        object = stateDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1));
        if (object != null) {
            object2 = ((Colors)object2).add(ColorType.LINE, (HtmlColor)object);
        }
        if (regexResult.get("LINECOLOR", 0) != null) {
            object2 = ((Colors)object2).addLegacyStroke(regexResult.get("LINECOLOR", 0));
        }
        iGroup2.setColors((Colors)object2);
        return CommandExecutionResult.ok();
    }
}

