/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernActiveLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernActor;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernArrow;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDelayLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDelayText;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernDivider;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernEnglober;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernGroupingHeader;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernLine;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernNewpage;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernNote;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernParticipant;
import net.sourceforge.plantuml.skin.bluemodern.ComponentBlueModernSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;

public class BlueModern
implements Skin {
    private final UFont bigFont = UFont.sansSerif(20).bold();
    private final UFont participantFont = UFont.sansSerif(17);
    private final UFont normalFont = UFont.sansSerif(13);
    private final UFont smallFont = UFont.sansSerif(11).bold();
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final HtmlColor blue1 = HtmlColorUtils.COL_527BC6;
    private final HtmlColor blue2 = HtmlColorUtils.COL_D1DBEF;
    private final HtmlColor blue3 = HtmlColorUtils.COL_D7E0F2;
    private final HtmlColor red = HtmlColorUtils.MY_RED;
    private final HtmlColor lineColor = HtmlColorUtils.COL_989898;
    private final HtmlColor borderGroupColor = HtmlColorUtils.COL_BBBBBB;

    public Component createComponent(ComponentType componentType, ArrowConfiguration arrowConfiguration, ISkinParam iSkinParam, Display display) {
        if (componentType.isArrow()) {
            HtmlColor htmlColor;
            HtmlColor htmlColor2 = htmlColor = arrowConfiguration.getColor() == null ? HtmlColorUtils.BLACK : arrowConfiguration.getColor();
            if (arrowConfiguration.isSelfArrow()) {
                return new ComponentBlueModernSelfArrow(htmlColor, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, arrowConfiguration, iSkinParam);
            }
            return new ComponentBlueModernArrow(htmlColor, true, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, arrowConfiguration, iSkinParam);
        }
        if (componentType == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentBlueModernParticipant(this.blue1, this.blue2, this.participantFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, iSkinParam);
        }
        if (componentType == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentBlueModernParticipant(this.blue1, this.blue2, this.participantFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, iSkinParam);
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            return new ComponentBlueModernLine(this.lineColor);
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            return new ComponentBlueModernLine(this.lineColor);
        }
        if (componentType == ComponentType.ACTOR_HEAD) {
            return new ComponentBlueModernActor(this.blue2, this.blue1, this.participantFont.toFont2(this.blue1, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, true, iSkinParam);
        }
        if (componentType == ComponentType.ACTOR_TAIL) {
            return new ComponentBlueModernActor(this.blue2, this.blue1, this.participantFont.toFont2(this.blue1, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, false, iSkinParam);
        }
        if (componentType == ComponentType.NOTE) {
            return new ComponentBlueModernNote(HtmlColorUtils.WHITE, HtmlColorUtils.BLACK, this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, iSkinParam);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentBlueModernActiveLine(this.blue1, true, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentBlueModernActiveLine(this.blue1, true, false);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentBlueModernActiveLine(this.blue1, false, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentBlueModernActiveLine(this.blue1, false, false);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            return new ComponentBlueModernDelayLine(this.lineColor);
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentBlueModernDelayText(iSkinParam.getFont(null, false, FontParam.SEQUENCE_DELAY).toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, iSkinParam);
        }
        if (componentType == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(this.red);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            return new ComponentBlueModernGroupingHeader(this.blue1, this.blue3, this.borderGroupColor, HtmlColorUtils.BLACK, this.normalFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor, iSkinParam.getTabSize()), this.smallFont, display, iSkinParam);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(HtmlColorUtils.BLACK, this.smallFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), display.get(0), iSkinParam, this.blue3);
        }
        if (componentType == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (componentType == ComponentType.REFERENCE) {
            return new ComponentRoseReference(this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), new SymbolContext(this.blue1, this.borderGroupColor).withStroke(Rose.getStroke(iSkinParam, LineParam.sequenceDividerBorder, 2.0)), this.normalFont.toFont2(HtmlColorUtils.WHITE, true, this.hyperlinkColor, iSkinParam.getTabSize()), display, HorizontalAlignment.CENTER, iSkinParam, this.blue3);
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentBlueModernNewpage(this.blue1);
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentBlueModernDivider(this.normalFont.toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), this.blue2, this.blue1, HtmlColorUtils.BLACK, display, iSkinParam);
        }
        if (componentType == ComponentType.ENGLOBER) {
            return new ComponentBlueModernEnglober(this.blue1, this.blue3, display, iSkinParam.getFont(null, false, FontParam.SEQUENCE_BOX).toFont2(HtmlColorUtils.BLACK, true, this.hyperlinkColor, iSkinParam.getTabSize()), iSkinParam);
        }
        return null;
    }

    public Object getProtocolVersion() {
        return 1;
    }
}

