/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class NotesTile
implements Tile {
    private final LivingSpaces livingSpaces;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Notes notes;

    public Event getEvent() {
        return this.notes;
    }

    public NotesTile(LivingSpaces livingSpaces, Notes notes, Skin skin, ISkinParam iSkinParam) {
        this.livingSpaces = livingSpaces;
        this.notes = notes;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder, Note note) {
        Component component = this.skin.createComponent(this.getNoteComponentType(note.getStyle()), null, note.getSkinParamBackcolored(this.skinParam), note.getStrings());
        return component;
    }

    private ComponentType getNoteComponentType(NoteStyle noteStyle) {
        if (noteStyle == NoteStyle.HEXAGONAL) {
            return ComponentType.NOTE_HEXAGONAL;
        }
        if (noteStyle == NoteStyle.BOX) {
            return ComponentType.NOTE_BOX;
        }
        return ComponentType.NOTE;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Note note : this.notes) {
            Component component = this.getComponent(stringBounder, note);
            Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
            double d = this.getX(stringBounder, note).getCurrentValue();
            Area area = new Area(this.getUsedWidth(stringBounder, note), dimension2D.getHeight());
            UGraphic uGraphic2 = uGraphic.apply(new UTranslate(d, 0.0));
            component.drawU(uGraphic2, area, (Context2D)((Object)uGraphic2));
        }
    }

    private double getUsedWidth(StringBounder stringBounder, Note note) {
        Component component = this.getComponent(stringBounder, note);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        return d;
    }

    private Real getXcenter(StringBounder stringBounder, Note note) {
        LivingSpace livingSpace = this.livingSpaces.get(note.getParticipant());
        return livingSpace.getPosC(stringBounder);
    }

    private Real getX(StringBounder stringBounder, Note note) {
        LivingSpace livingSpace = this.livingSpaces.get(note.getParticipant());
        NotePosition notePosition = note.getPosition();
        double d = this.getUsedWidth(stringBounder, note);
        if (notePosition == NotePosition.LEFT) {
            return livingSpace.getPosC(stringBounder).addFixed(-d);
        }
        if (notePosition == NotePosition.RIGHT) {
            int n = livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            double d2 = (double)n * 5.0;
            return livingSpace.getPosC(stringBounder).addFixed(d2);
        }
        if (notePosition == NotePosition.OVER_SEVERAL) {
            LivingSpace livingSpace2 = this.livingSpaces.get(note.getParticipant2());
            Real real = livingSpace.getPosC(stringBounder);
            Real real2 = livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(real, real2).addFixed(-d / 2.0);
        }
        if (notePosition == NotePosition.OVER) {
            return livingSpace.getPosC(stringBounder).addFixed(-d / 2.0);
        }
        throw new UnsupportedOperationException(notePosition.toString());
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (Note note : this.notes) {
            Component component = this.getComponent(stringBounder, note);
            Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
            d = Math.max(d, dimension2D.getHeight());
        }
        return d;
    }

    public void addConstraints(StringBounder stringBounder) {
        List<Note> list = this.notes.asList();
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                Real real;
                Real real2;
                double d = this.getXcenter(stringBounder, list.get(i)).getCurrentValue();
                double d2 = this.getXcenter(stringBounder, list.get(j)).getCurrentValue();
                if (d2 > d) {
                    real2 = this.getX2(stringBounder, list.get(i));
                    real = this.getX(stringBounder, list.get(j));
                    real.ensureBiggerThan(real2);
                    continue;
                }
                real2 = this.getX(stringBounder, list.get(i));
                real = this.getX2(stringBounder, list.get(j));
                real2.ensureBiggerThan(real);
            }
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        ArrayList<Real> arrayList = new ArrayList<Real>();
        for (Note note : this.notes) {
            arrayList.add(this.getX(stringBounder, note));
        }
        return RealUtils.min(arrayList);
    }

    private Real getX2(StringBounder stringBounder, Note note) {
        return this.getX(stringBounder, note).addFixed(this.getUsedWidth(stringBounder, note));
    }

    public Real getMaxX(StringBounder stringBounder) {
        ArrayList<Real> arrayList = new ArrayList<Real>();
        for (Note note : this.notes) {
            arrayList.add(this.getX2(stringBounder, note));
        }
        return RealUtils.max(arrayList);
    }
}

