/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import net.sourceforge.plantuml.sequencediagram.teoz.Englobers;
import net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.UGraphicInterceptorTile;
import net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class MainTile
implements Tile,
Bordered {
    private final double startingY = 8.0;
    private final Real min;
    private final Real max;
    private final boolean isShowFootbox;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final LivingSpaces livingSpaces;

    public MainTile(SequenceDiagram sequenceDiagram, Englobers englobers, TileArguments tileArguments) {
        this.livingSpaces = tileArguments.getLivingSpaces();
        ArrayList<Real> arrayList = new ArrayList<Real>();
        ArrayList<Real> arrayList2 = new ArrayList<Real>();
        arrayList.add(tileArguments.getOrigin());
        arrayList2.add(tileArguments.getOrigin());
        if (englobers.size() > 0) {
            arrayList.add(englobers.getMinX(tileArguments.getStringBounder()));
            arrayList2.add(englobers.getMaxX(tileArguments.getStringBounder()));
        }
        this.tiles.addAll(TileBuilder.buildSeveral(sequenceDiagram.events().iterator(), tileArguments, null));
        for (Tile object : this.tiles) {
            arrayList.add(object.getMinX(tileArguments.getStringBounder()));
            arrayList2.add(object.getMaxX(tileArguments.getStringBounder()));
        }
        for (LivingSpace livingSpace : this.livingSpaces.values()) {
            arrayList2.add(livingSpace.getPosD(tileArguments.getStringBounder()));
            arrayList2.add(livingSpace.getPosC2(tileArguments.getStringBounder()));
        }
        this.min = RealUtils.min(arrayList);
        this.max = RealUtils.max(arrayList2);
        this.isShowFootbox = sequenceDiagram.isShowFootbox();
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        LiveBoxFinder liveBoxFinder = new LiveBoxFinder(stringBounder);
        this.drawUInternal(liveBoxFinder, false);
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(uGraphic, true);
        this.drawUInternal(uGraphicInterceptorTile, false);
    }

    public void drawForeground(UGraphic uGraphic) {
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(uGraphic, false);
        this.drawUInternal(uGraphicInterceptorTile, false);
    }

    private double drawUInternal(UGraphic uGraphic, boolean bl) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        ArrayList<YPositionedTile> arrayList = new ArrayList<YPositionedTile>();
        double d = GroupingTile.fillPositionelTiles(stringBounder, 8.0, this.tiles, arrayList);
        for (YPositionedTile yPositionedTile : arrayList) {
            yPositionedTile.drawU(uGraphic);
        }
        return d;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(limitFinder, false);
        double d = this.drawUInternal(uGraphicInterceptorTile, false);
        double d2 = Math.max(limitFinder.getMinMax().getDimension().getHeight(), d) + 10.0;
        return d2;
    }

    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    public Event getEvent() {
        return null;
    }

    public boolean isShowFootbox() {
        return this.isShowFootbox;
    }

    public LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    public double getBorder1() {
        return this.min.getCurrentValue();
    }

    public double getBorder2() {
        return this.max.getCurrentValue();
    }
}

