/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramArea {
    private final double sequenceWidth;
    private final double sequenceHeight;
    private double headerWidth;
    private double headerHeight;
    private double headerMargin;
    private double titleWidth;
    private double titleHeight;
    private double captionWidth;
    private double captionHeight;
    private double footerWidth;
    private double footerHeight;
    private double footerMargin;

    public SequenceDiagramArea(double d, double d2) {
        this.sequenceWidth = d;
        this.sequenceHeight = d2;
    }

    public void setTitleArea(double d, double d2) {
        this.titleWidth = d;
        this.titleHeight = d2;
    }

    private void setCaptionArea(double d, double d2) {
        this.captionWidth = d;
        this.captionHeight = d2;
    }

    public void setCaptionArea(Dimension2D dimension2D) {
        this.setCaptionArea(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setHeaderArea(double d, double d2, double d3) {
        this.headerWidth = d;
        this.headerHeight = d2;
        this.headerMargin = d3;
    }

    public void setFooterArea(double d, double d2, double d3) {
        this.footerWidth = d;
        this.footerHeight = d2;
        this.footerMargin = d3;
    }

    public double getWidth() {
        return MathUtils.max(this.sequenceWidth, this.headerWidth, this.titleWidth, this.footerWidth, this.captionWidth);
    }

    public double getHeight() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.footerHeight + this.captionHeight;
    }

    public double getTitleX() {
        return (this.getWidth() - this.titleWidth) / 2.0;
    }

    public double getTitleY() {
        return this.headerHeight + this.headerMargin;
    }

    public double getCaptionX() {
        return (this.getWidth() - this.captionWidth) / 2.0;
    }

    public double getCaptionY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight;
    }

    public double getSequenceAreaX() {
        return (this.getWidth() - this.sequenceWidth) / 2.0;
    }

    public double getSequenceAreaY() {
        return this.getTitleY() + this.titleHeight;
    }

    public double getHeaderY() {
        return 0.0;
    }

    public double getFooterY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.captionHeight;
    }

    public double getFooterX(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.footerWidth;
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.footerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public double getHeaderX(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.headerWidth;
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.headerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public void initFooter(PngTitler pngTitler, StringBounder stringBounder) {
        Dimension2D dimension2D = pngTitler.getTextDimension(stringBounder);
        if (dimension2D != null) {
            this.setFooterArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    public void initHeader(PngTitler pngTitler, StringBounder stringBounder) {
        Dimension2D dimension2D = pngTitler.getTextDimension(stringBounder);
        if (dimension2D != null) {
            this.setHeaderArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }
}

