/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Englober;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawableSet {
    private final Map<Participant, LivingParticipantBox> participants = new LinkedHashMap<Participant, LivingParticipantBox>();
    private final Map<Event, GraphicalElement> events = new HashMap<Event, GraphicalElement>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new LinkedHashMap<Participant, ParticipantEnglober>();
    private final List<Event> eventsList = new ArrayList<Event>();
    private final Skin skin;
    private final ISkinParam skinParam;
    private Dimension2D dimension;
    private double topStartingY;
    private static final int MARGIN_FOR_ENGLOBERS = 4;
    private static final int MARGIN_FOR_ENGLOBERS1 = 2;

    DrawableSet(Skin skin, ISkinParam iSkinParam) {
        if (skin == null) {
            throw new IllegalArgumentException();
        }
        if (iSkinParam == null) {
            throw new IllegalArgumentException();
        }
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public ParticipantBox getVeryfirst() {
        return this.participants.values().iterator().next().getParticipantBox();
    }

    public final Skin getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Collection<Event> getAllEvents() {
        return Collections.unmodifiableCollection(this.eventsList);
    }

    public Set<Participant> getAllParticipants() {
        return Collections.unmodifiableSet(this.participants.keySet());
    }

    public Collection<LivingParticipantBox> getAllLivingParticipantBox() {
        return Collections.unmodifiableCollection(this.participants.values());
    }

    public Collection<GraphicalElement> getAllGraphicalElements() {
        ArrayList<GraphicalElement> arrayList = new ArrayList<GraphicalElement>();
        for (Event event : this.eventsList) {
            arrayList.add(this.events.get(event));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public LivingParticipantBox getLivingParticipantBox(Participant participant) {
        return this.participants.get(participant);
    }

    public GraphicalElement getEvent(Event event) {
        return this.events.get(event);
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (Participant participant : this.participants.keySet()) {
            double d2 = this.getHeadAndEngloberHeight(participant, stringBounder);
            d = Math.max(d, d2);
        }
        return d;
    }

    public double getHeadAndEngloberHeight(Participant participant, StringBounder stringBounder) {
        LivingParticipantBox livingParticipantBox = this.participants.get(participant);
        double d = livingParticipantBox.getParticipantBox().getHeadHeight(stringBounder);
        Englober englober = this.getParticipantEnglober(participant, stringBounder);
        if (englober == null) {
            return d;
        }
        Component component = this.skin.createComponent(ComponentType.ENGLOBER, null, this.skinParam, englober.getParticipantEnglober().getTitle());
        double d2 = component.getPreferredHeight(stringBounder);
        return d + d2;
    }

    public List<Englober> getExistingParticipantEnglober(StringBounder stringBounder) {
        ArrayList<Englober> arrayList = new ArrayList<Englober>();
        Englober englober = null;
        for (Map.Entry<Participant, ParticipantEnglober> entry : this.participantEnglobers2.entrySet()) {
            ParticipantEnglober participantEnglober = entry.getValue();
            if (participantEnglober == null) {
                englober = null;
                continue;
            }
            assert (participantEnglober != null);
            if (englober != null && participantEnglober == englober.getParticipantEnglober()) {
                englober.add(entry.getKey());
                continue;
            }
            englober = new Englober(participantEnglober, entry.getKey(), this.getSkinParam(), this.skin, stringBounder);
            arrayList.add(englober);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double d = 0.0;
        for (Englober englober : this.getExistingParticipantEnglober(stringBounder)) {
            Component component = this.skin.createComponent(ComponentType.ENGLOBER, null, this.skinParam, englober.getParticipantEnglober().getTitle());
            double d2 = component.getPreferredHeight(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getTailHeight(StringBounder stringBounder, boolean bl) {
        double d;
        double d2 = d = this.getExistingParticipantEnglober(stringBounder).size() > 0 ? 4.0 : 0.0;
        if (!bl) {
            return 1.0 + d;
        }
        double d3 = 0.0;
        for (LivingParticipantBox livingParticipantBox : this.participants.values()) {
            double d4 = livingParticipantBox.getParticipantBox().getTailHeight(stringBounder);
            d3 = Math.max(d3, d4);
        }
        return d3 + d;
    }

    public void addParticipant(Participant participant, ParticipantEnglober participantEnglober) {
        this.participants.put(participant, null);
        this.participantEnglobers2.put(participant, participantEnglober);
    }

    public void setLivingParticipantBox(Participant participant, LivingParticipantBox livingParticipantBox) {
        if (!this.participants.containsKey(participant)) {
            throw new IllegalArgumentException();
        }
        this.participants.put(participant, livingParticipantBox);
    }

    public void addEvent(Event event, GraphicalElement graphicalElement) {
        if (!this.events.keySet().contains(event)) {
            this.eventsList.add(event);
        }
        this.events.put(event, graphicalElement);
    }

    public void addEvent(Newpage newpage, GraphicalNewpage graphicalNewpage, Event event) {
        int n = this.eventsList.indexOf(event);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.eventsList.add(n, newpage);
        this.events.put(newpage, graphicalNewpage);
        assert (this.events.size() == this.eventsList.size());
    }

    void setDimension(Dimension2D dimension2D) {
        if (this.dimension != null) {
            throw new IllegalStateException();
        }
        this.dimension = dimension2D;
    }

    public Dimension2D getDimension() {
        return this.dimension;
    }

    void drawU22(UGraphic uGraphic, double d, double d2, Page page, boolean bl) {
        double d3 = page.getHeight();
        UGraphic uGraphic2 = this.clipAndTranslate2(d, d2, page, uGraphic);
        SimpleContext2D simpleContext2D = new SimpleContext2D(true);
        this.drawEnglobers(uGraphic, d3 - 2.0, simpleContext2D);
        this.drawPlaygroundU(uGraphic2, simpleContext2D);
        this.drawLineU22(uGraphic, bl, page);
        this.drawHeadTailU(uGraphic, page, bl ? d3 - this.getTailHeight(uGraphic.getStringBounder(), true) : 0.0);
        this.drawPlaygroundU(uGraphic2, new SimpleContext2D(false));
    }

    private UGraphic clipAndTranslate2(double d, double d2, Page page, UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UClip(0.0, page.getBodyRelativePosition(), d2, page.getBodyHeight() + 1.0));
        if (d > 0.0) {
            uGraphic = uGraphic.apply(new UTranslate(0.0, -d));
        }
        return uGraphic;
    }

    private void drawLineU22(UGraphic uGraphic, boolean bl, Page page) {
        boolean bl2 = uGraphic instanceof UGraphicTxt;
        for (LivingParticipantBox livingParticipantBox : this.getAllLivingParticipantBox()) {
            double d = livingParticipantBox.getCreate();
            double d2 = page.getBodyRelativePosition() - livingParticipantBox.magicMargin(uGraphic.getStringBounder());
            double d3 = d2 + page.getBodyHeight() + 2.0 * livingParticipantBox.magicMargin(uGraphic.getStringBounder());
            double d4 = d2;
            if (d > 0.0) {
                if (d > page.getNewpage2()) continue;
                if (d >= page.getNewpage1() && d < page.getNewpage2()) {
                    d4 = bl2 ? (double)((int)d) : (d4 += d - page.getNewpage1() + 2.0 * livingParticipantBox.magicMargin(uGraphic.getStringBounder()));
                }
            }
            double d5 = page.getNewpage1() - page.getHeaderHeight();
            livingParticipantBox.drawLineU22(uGraphic, d4, d3, bl, d5);
        }
    }

    private void drawHeadTailU(UGraphic uGraphic, Page page, double d) {
        for (Map.Entry<Participant, LivingParticipantBox> entry : this.participants.entrySet()) {
            Url url;
            Participant participant = entry.getKey();
            LivingParticipantBox livingParticipantBox = entry.getValue();
            double d2 = livingParticipantBox.getCreate();
            boolean bl = true;
            if (d2 > 0.0) {
                if (d2 > page.getNewpage2()) continue;
                if (d2 >= page.getNewpage1() && d2 < page.getNewpage2()) {
                    bl = false;
                }
            }
            if ((url = participant.getUrl()) != null) {
                uGraphic.startUrl(url);
            }
            livingParticipantBox.getParticipantBox().drawHeadTailU(uGraphic, this.topStartingY, bl, d);
            if (url == null) continue;
            uGraphic.closeAction();
        }
    }

    private double getMaxX() {
        return this.dimension.getWidth();
    }

    private double getMaxY() {
        return this.dimension.getHeight();
    }

    private void drawPlaygroundU(UGraphic uGraphic, Context2D context2D) {
        for (Participant object : this.getAllParticipants()) {
            this.drawLifeLineU(uGraphic, object);
        }
        for (GraphicalElement graphicalElement : this.getAllGraphicalElements()) {
            graphicalElement.drawU(uGraphic, this.getMaxX(), context2D);
        }
    }

    private void drawEnglobers(UGraphic uGraphic, double d, Context2D context2D) {
        for (Englober englober : this.getExistingParticipantEnglober(uGraphic.getStringBounder())) {
            Dimension2DDouble dimension2DDouble;
            double d2 = this.getX1(englober);
            double d3 = this.getX2(uGraphic.getStringBounder(), englober);
            Component component = this.getEngloberComponent(englober.getParticipantEnglober());
            double d4 = d3 - d2;
            double d5 = this.getEngloberPreferedWidth(uGraphic.getStringBounder(), englober.getParticipantEnglober());
            if (d5 > d4) {
                dimension2DDouble = new Dimension2DDouble(d5, d);
                component.drawU(uGraphic.apply(new UTranslate(d2 -= (d5 - d4) / 2.0, 1.0)), new Area(dimension2DDouble), context2D);
                continue;
            }
            dimension2DDouble = new Dimension2DDouble(d4, d);
            component.drawU(uGraphic.apply(new UTranslate(d2, 1.0)), new Area(dimension2DDouble), context2D);
        }
    }

    public double getEngloberPreferedWidth(StringBounder stringBounder, ParticipantEnglober participantEnglober) {
        return this.getEngloberComponent(participantEnglober).getPreferredWidth(stringBounder);
    }

    private Component getEngloberComponent(ParticipantEnglober participantEnglober) {
        ISkinParam iSkinParam = participantEnglober.getBoxColor() == null ? this.skinParam : new SkinParamBackcolored(this.skinParam, participantEnglober.getBoxColor());
        return this.skin.createComponent(ComponentType.ENGLOBER, null, iSkinParam, participantEnglober.getTitle());
    }

    public double getX1(Englober englober) {
        Participant participant = englober.getFirst2TOBEPRIVATE();
        ParticipantBox participantBox = this.participants.get(participant).getParticipantBox();
        return participantBox.getStartingX() + 1.0;
    }

    public double getX2(StringBounder stringBounder, Englober englober) {
        Participant participant = englober.getLast2TOBEPRIVATE();
        ParticipantBox participantBox = this.participants.get(participant).getParticipantBox();
        return participantBox.getMaxX(stringBounder) - 1.0;
    }

    private void drawLifeLineU(UGraphic uGraphic, Participant participant) {
        LifeLine lifeLine = this.getLivingParticipantBox(participant).getLifeLine();
        lifeLine.finish(this.getMaxY());
        lifeLine.drawU(uGraphic, this.getSkin(), this.skinParam);
    }

    private Englober getParticipantEnglober(Participant participant, StringBounder stringBounder) {
        for (Englober englober : this.getExistingParticipantEnglober(stringBounder)) {
            if (!englober.contains(participant)) continue;
            return englober;
        }
        return null;
    }

    public void setTopStartingY(double d) {
        this.topStartingY = d;
    }

    Participant getFirst(Collection<Participant> collection) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.participants.keySet());
        int n = -1;
        for (Participant participant : collection) {
            int n2 = arrayList.indexOf(participant);
            assert (n2 != -1);
            if (n != -1 && n <= n2) continue;
            n = n2;
        }
        return (Participant)arrayList.get(n);
    }

    Participant getLast(Collection<Participant> collection) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.participants.keySet());
        int n = -1;
        for (Participant participant : collection) {
            int n2 = arrayList.indexOf(participant);
            assert (n2 != -1);
            if (n != -1 && n >= n2) continue;
            n = n2;
        }
        return (Participant)arrayList.get(n);
    }

    public double getArrowThickness() {
        UStroke uStroke = this.skinParam.getThickness(LineParam.sequenceArrow, null);
        if (uStroke == null) {
            return 1.0;
        }
        return uStroke.getThickness();
    }
}

