/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandGrouping
extends SingleLineCommand2<SequenceDiagram> {
    public CommandGrouping() {
        super(CommandGrouping.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(opt|alt|loop|par|par2|break|critical|else|end|also|group)"), new RegexLeaf("COLORS", "((?<!else)(?<!also)(?<!end)#\\w+)?(?:[%s]+(#\\w+))?"), new RegexLeaf("COMMENT", "(?:[%s]+(.*?))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        boolean bl;
        String string = StringUtils.goLowerCase(regexResult.get("TYPE", 0));
        HtmlColor htmlColor = sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLORS", 0));
        HtmlColor htmlColor2 = sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLORS", 1), true);
        String string2 = regexResult.get("COMMENT", 0);
        GroupingType groupingType = GroupingType.getType(string);
        if ("group".equals(string)) {
            if (StringUtils.isEmpty(string2)) {
                string2 = "group";
            } else {
                Pattern pattern = Pattern.compile("^(.*?)\\[(.*)\\]$");
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    string = matcher.group(1);
                    string2 = matcher.group(2);
                }
            }
        }
        if (!(bl = sequenceDiagram.grouping(string, string2, groupingType, htmlColor2, htmlColor))) {
            return CommandExecutionResult.error("Cannot create group");
        }
        return CommandExecutionResult.ok();
    }
}

