/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;

public class NoteOnMessage {
    private final Display notes;
    private final NotePosition notePosition;
    private final NoteStyle noteStyle;
    private final HtmlColor noteBackColor;
    private final Url urlNote;

    public NoteOnMessage(Display display, NotePosition notePosition, NoteStyle noteStyle, String string, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.noteStyle = noteStyle;
        this.notes = display;
        this.urlNote = url;
        this.notePosition = notePosition;
        this.noteBackColor = HtmlColorSet.getInstance().getColorIfValid(string);
    }

    public SkinParamBackcolored getSkinParamNoteBackcolored(ISkinParam iSkinParam) {
        return new SkinParamBackcolored(iSkinParam, this.noteBackColor);
    }

    public boolean hasUrl() {
        if (this.notes != null && this.notes.hasUrl()) {
            return true;
        }
        return this.urlNote != null;
    }

    public Display getDisplay() {
        return this.notes;
    }

    public NotePosition getNotePosition() {
        return this.notePosition;
    }

    public NoteStyle getNoteStyle() {
        return this.noteStyle;
    }

    public Url getUrlNote() {
        return this.urlNote;
    }
}

