/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Note
extends AbstractEvent
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private final NotePosition position;
    private NoteStyle style = NoteStyle.NORMAL;
    private Url url;
    private Colors colors = Colors.empty();

    public Note(Participant participant, NotePosition notePosition, Display display) {
        this(participant, null, notePosition, display);
    }

    public Note(Participant participant, Participant participant2, Display display) {
        this(participant, participant2, NotePosition.OVER_SEVERAL, display);
    }

    private Note(Participant participant, Participant participant2, NotePosition notePosition, Display display) {
        this.p = participant;
        this.p2 = participant2;
        this.position = notePosition;
        this.strings = display;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    public Colors getColors(ISkinParam iSkinParam) {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public boolean dealWith(Participant participant) {
        return this.p == participant || this.p2 == participant;
    }

    public Url getUrl() {
        return this.url;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public final NoteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(NoteStyle noteStyle) {
        this.style = noteStyle;
    }

    public ISkinParam getSkinParamBackcolored(ISkinParam iSkinParam) {
        return this.colors.mute(iSkinParam);
    }

    public void setStereotype(Stereotype stereotype) {
    }

    public String toString() {
        return super.toString() + " " + this.strings;
    }

    public void setUrl(Url url) {
        this.url = url;
    }
}

