/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElementElse;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageExoArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InGroupableList
implements InGroupable {
    private static final int MARGIN5 = 5;
    public static final int MARGIN10 = 10;
    private final Grouping grouping;
    private final Set<InGroupable> inGroupables = new HashSet<InGroupable>();
    private double minWidth;
    private final ParticipantBox veryfirst;
    private InGroupable cacheMin = null;
    private InGroupable cacheMax = null;
    private double hack2;

    public List<InGroupableList> getInnerList() {
        ArrayList<InGroupableList> arrayList = new ArrayList<InGroupableList>();
        for (InGroupable inGroupable : this.inGroupables) {
            if (!(inGroupable instanceof InGroupableList)) continue;
            arrayList.add((InGroupableList)inGroupable);
        }
        return arrayList;
    }

    public InGroupableList(ParticipantBox participantBox, Grouping grouping, double d) {
        this.grouping = grouping;
        this.veryfirst = participantBox;
    }

    public void addInGroupable(InGroupable inGroupable) {
        this.inGroupables.add(inGroupable);
        this.cacheMin = null;
        this.cacheMax = null;
    }

    public boolean isEmpty() {
        return this.inGroupables.isEmpty();
    }

    public String toString() {
        return "GS " + this.grouping + " " + this.inGroupables.toString();
    }

    @Override
    public String toString(StringBounder stringBounder) {
        StringBuilder stringBuilder = new StringBuilder("GS " + this.grouping + " ");
        for (InGroupable inGroupable : this.inGroupables) {
            stringBuilder.append(inGroupable.toString(stringBounder));
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private InGroupable getMinSlow(StringBounder stringBounder) {
        InGroupable inGroupable = null;
        for (InGroupable inGroupable2 : this.inGroupables) {
            if (inGroupable2 instanceof GroupingGraphicalElementElse || inGroupable != null && !(inGroupable2.getMinX(stringBounder) < inGroupable.getMinX(stringBounder))) continue;
            inGroupable = inGroupable2;
        }
        return inGroupable;
    }

    private InGroupable getMaxSlow(StringBounder stringBounder) {
        InGroupable inGroupable = null;
        for (InGroupable inGroupable2 : this.inGroupables) {
            if (inGroupable != null && !(inGroupable2.getMaxX(stringBounder) > inGroupable.getMaxX(stringBounder))) continue;
            inGroupable = inGroupable2;
        }
        return inGroupable;
    }

    private InGroupable getMin(StringBounder stringBounder) {
        if (this.cacheMin == null) {
            this.cacheMin = this.getMinSlow(stringBounder);
        }
        assert (this.cacheMin == this.getMinSlow(stringBounder));
        return this.cacheMin;
    }

    private InGroupable getMax(StringBounder stringBounder) {
        if (this.cacheMax == null) {
            this.cacheMax = this.getMaxSlow(stringBounder);
        }
        assert (this.cacheMax == this.getMaxSlow(stringBounder));
        return this.cacheMax;
    }

    public void setMinWidth(double d) {
        this.minWidth = d;
    }

    public ParticipantBox getFirstParticipantBox() {
        ParticipantBox participantBox = null;
        for (InGroupable inGroupable : this.inGroupables) {
            if (!(inGroupable instanceof LivingParticipantBox)) continue;
            ParticipantBox participantBox2 = ((LivingParticipantBox)inGroupable).getParticipantBox();
            if (participantBox != null && !(participantBox2.getStartingX() < participantBox.getStartingX())) continue;
            participantBox = participantBox2;
        }
        return participantBox;
    }

    public ParticipantBox getLastParticipantBox() {
        ParticipantBox participantBox = null;
        for (InGroupable inGroupable : this.inGroupables) {
            if (!(inGroupable instanceof LivingParticipantBox)) continue;
            ParticipantBox participantBox2 = ((LivingParticipantBox)inGroupable).getParticipantBox();
            if (participantBox != null && !(participantBox2.getStartingX() > participantBox.getStartingX())) continue;
            participantBox = participantBox2;
        }
        return participantBox;
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        InGroupable inGroupable = this.getMin(stringBounder);
        if (inGroupable == null) {
            return 15.0 + (this.veryfirst == null ? 0.0 : this.veryfirst.getStartingX());
        }
        double d = inGroupable.getMinX(stringBounder);
        d = inGroupable instanceof MessageExoArrow && (((MessageExoArrow)inGroupable).getType() == MessageExoType.FROM_LEFT || ((MessageExoArrow)inGroupable).getType() == MessageExoType.TO_LEFT) ? (d += 3.0) : (inGroupable instanceof InGroupableList ? (d -= 10.0) : (d -= 5.0));
        return d;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        double d = this.getMinX(stringBounder);
        double d2 = this.getMaxXInternal(stringBounder);
        assert (d2 - d >= 0.0);
        if (d2 - d < this.minWidth) {
            return d + this.minWidth + this.hack2;
        }
        return d2 + this.hack2;
    }

    private final double getMaxXInternal(StringBounder stringBounder) {
        InGroupable inGroupable = this.getMax(stringBounder);
        if (inGroupable == null) {
            return 15.0 + this.minWidth;
        }
        double d = inGroupable.getMaxX(stringBounder);
        d = inGroupable instanceof MessageExoArrow && (((MessageExoArrow)inGroupable).getType() == MessageExoType.FROM_RIGHT || ((MessageExoArrow)inGroupable).getType() == MessageExoType.TO_RIGHT) ? (d -= 3.0) : (inGroupable instanceof InGroupableList ? (d += 10.0) : (d += 5.0));
        return d;
    }

    public void changeHack2(double d) {
        this.hack2 += d;
    }

    public double getHack2() {
        return this.hack2;
    }
}

