/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.ElementText;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactoryPyramid
extends AbstractElementFactoryComplex {
    public ElementFactoryPyramid(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        Terminated terminated;
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated terminated2 = (Terminated)this.getDataSource().next();
        String string = (String)terminated2.getElement();
        assert (string.startsWith("{"));
        String string2 = null;
        TableStrategy tableStrategy = TableStrategy.DRAW_NONE;
        if (string.length() == 2) {
            tableStrategy = TableStrategy.fromChar(string.charAt(1));
        }
        if (tableStrategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE && terminated2.getTerminator() == Terminator.NEWCOL) {
            string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote((String)((Terminated)this.getDataSource().next()).getElement(), "\"");
        }
        Positionner2 positionner2 = new Positionner2();
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            terminated = this.getNextElement();
            if (this.isStar((Element)terminated.getElement())) {
                positionner2.mergeLeft(terminated.getTerminator());
                continue;
            }
            positionner2.add(terminated);
        }
        terminated = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(new ElementPyramid(positionner2, tableStrategy, string2, this.getDictionary()), terminated.getTerminator());
    }

    private boolean isStar(Element element) {
        if (!(element instanceof ElementText)) {
            return false;
        }
        return "*".equals(((ElementText)element).getText());
    }

    @Override
    public boolean ready() {
        String string = this.getDataSource().peek(0).getElement();
        if (string.equals("{") || string.equals("{+") || string.equals("{^") || string.equals("{#") || string.equals("{!") || string.equals("{-")) {
            String string2 = this.getDataSource().peek(1).getElement();
            return !string2.matches("[NSEW]=|T");
        }
        return false;
    }
}

