/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Duration;
import net.sourceforge.plantuml.project3.DurationDay;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.Solver;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskCode;
import net.sourceforge.plantuml.project3.TaskDraw;

public class TaskImpl
implements Task {
    private final TaskCode code;
    private final Solver solver = new Solver();
    private TaskDraw taskDraw;
    private ComplementColors colors;

    public TaskImpl(TaskCode taskCode) {
        this.code = taskCode;
        this.setStart(new InstantDay(0));
        this.setDuration(new DurationDay(1));
    }

    public String toString() {
        return this.code.toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getDuration() + "]";
    }

    public TaskCode getCode() {
        return this.code;
    }

    public Instant getStart() {
        return (Instant)this.solver.getData(TaskAttribute.START);
    }

    public Instant getEnd() {
        return (Instant)this.solver.getData(TaskAttribute.END);
    }

    public Duration getDuration() {
        return (Duration)this.solver.getData(TaskAttribute.DURATION);
    }

    public void setStart(Instant instant) {
        this.solver.setData(TaskAttribute.START, instant);
    }

    public void setEnd(Instant instant) {
        this.solver.setData(TaskAttribute.END, instant);
    }

    public void setDuration(Duration duration) {
        this.solver.setData(TaskAttribute.DURATION, duration);
    }

    public void setTaskDraw(TaskDraw taskDraw) {
        taskDraw.setColors(this.colors);
        this.taskDraw = taskDraw;
    }

    public TaskDraw getTaskDraw() {
        return this.taskDraw;
    }

    public void setColors(ComplementColors complementColors) {
        this.colors = complementColors;
    }
}

