/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.preproc.DefineSignature;
import net.sourceforge.plantuml.preproc.Variables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Define {
    private final DefineSignature signature;
    private final String definition;
    private final String definitionQuoted;
    private final boolean emptyParentheses;

    public Define(String string, List<String> list, boolean bl) {
        this.signature = new DefineSignature(string);
        this.emptyParentheses = bl;
        if (list == null) {
            this.definition = null;
            this.definitionQuoted = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append('\n');
            }
            this.definition = stringBuilder.toString();
            this.definitionQuoted = Matcher.quoteReplacement(this.definition);
        }
    }

    public String toString() {
        return this.signature.toString();
    }

    public String apply(String string) {
        if (this.definition == null) {
            return string;
        }
        if (this.signature.isMethod()) {
            for (Variables variables : this.signature.getVariationVariables()) {
                string = variables.applyOn(string, this.signature.getFonctionName(), this.definitionQuoted);
            }
        } else {
            String string2 = "\\b" + this.signature.getKey() + "\\b" + (this.emptyParentheses ? "(\\(\\))?" : "");
            string = BackSlash.translateBackSlashes(string);
            string = string.replaceAll(string2, this.definitionQuoted);
            string = BackSlash.untranslateBackSlashes(string);
        }
        return string;
    }
}

