/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class PostIt {
    private final String id;
    private final Display text;
    private Dimension2D minimumDimension;

    public PostIt(String string, Display display) {
        this.id = string;
        this.text = display;
    }

    public String getId() {
        return this.id;
    }

    public Display getText() {
        return this.text;
    }

    public Dimension2D getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimumDimension(Dimension2D dimension2D) {
        this.minimumDimension = dimension2D;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        double d = this.getComponent().getPreferredWidth(stringBounder);
        double d2 = this.getComponent().getPreferredHeight(stringBounder);
        if (this.minimumDimension != null && d < this.minimumDimension.getWidth()) {
            d = this.minimumDimension.getWidth();
        }
        if (this.minimumDimension != null && d2 < this.minimumDimension.getHeight()) {
            d2 = this.minimumDimension.getHeight();
        }
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic) {
        Component component = this.getComponent();
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        component.drawU(uGraphic, new Area(dimension2D), new SimpleContext2D(false));
    }

    private Component getComponent() {
        HtmlColor htmlColor = new HtmlColorSetSimple().getColorIfValid("#FBFB77");
        HtmlColor htmlColor2 = HtmlColorUtils.MY_RED;
        SkinParam skinParam = SkinParam.noShadowing(null);
        UFont uFont = skinParam.getFont(null, false, FontParam.NOTE);
        FontConfiguration fontConfiguration = uFont.toFont2(HtmlColorUtils.BLACK, true, HtmlColorUtils.BLUE, 8);
        ComponentRoseNote componentRoseNote = new ComponentRoseNote(new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke()), fontConfiguration, this.text, 0.0, 0.0, new SpriteContainerEmpty());
        return componentRoseNote;
    }
}

