/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dijkstra {
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public Vertex addVertex(Object object) {
        Vertex vertex2 = new Vertex(object);
        this.vertices.add(vertex2);
        return vertex2;
    }

    private void computePaths(Vertex vertex2) {
        vertex2.minDistance = 0.0;
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>();
        priorityQueue.add(vertex2);
        while (!priorityQueue.isEmpty()) {
            Vertex vertex3 = (Vertex)priorityQueue.poll();
            for (Edge edge : vertex3.adjacencies) {
                Vertex vertex4 = edge.target;
                double d = edge.weight;
                double d2 = vertex3.minDistance + d;
                if (!(d2 < vertex4.minDistance)) continue;
                priorityQueue.remove(vertex4);
                vertex4.minDistance = d2;
                vertex4.previous = vertex3;
                priorityQueue.add(vertex4);
            }
        }
    }

    public List<Vertex> getShortestPathTo(Vertex vertex2, Vertex vertex3) {
        this.computePaths(vertex2);
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        Vertex vertex4 = vertex3;
        while (vertex4 != null) {
            arrayList.add(0, vertex4);
            vertex4 = vertex4.previous;
        }
        return arrayList;
    }

    static class Edge {
        private final Vertex target;
        private final double weight;

        Edge(Vertex vertex2, double d) {
            this.target = vertex2;
            this.weight = d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Vertex
    implements Comparable<Vertex> {
        private final Object data;
        private final List<Edge> adjacencies = new ArrayList<Edge>();
        private double minDistance = Double.POSITIVE_INFINITY;
        private Vertex previous;

        Vertex(Object object) {
            this.data = object;
        }

        public void addAdjacencies(Vertex vertex2, double d) {
            if (vertex2 == null) {
                throw new IllegalArgumentException();
            }
            this.adjacencies.add(new Edge(vertex2, d));
        }

        public String toString() {
            return "[ " + this.data.toString() + " (" + this.minDistance + ") ] ";
        }

        @Override
        public int compareTo(Vertex vertex2) {
            return Double.compare(this.minDistance, vertex2.minDistance);
        }

        public final Object getData() {
            return this.data;
        }
    }
}

