/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkElement
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandLinkElement() {
        super(CommandLinkElement.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkElement.getGroup("ENT1"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL1", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexLeaf("HEAD2", "(0\\)|<<|[<^*+#0)]|<\\||[%s]+o)?"), new RegexLeaf("BODY1", "([-=.~]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("DIRECTION", "(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.~0()]))?"), new RegexLeaf("INSIDE", "(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("BODY2", "([-=.~]*)"), new RegexLeaf("HEAD1", "(\\(0|>>|[>^*+#0(]|\\|>|o[%s]+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL2", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), CommandLinkElement.getGroup("ENT2"), new RegexLeaf("[%s]*"), CommandLinkElement.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private LinkType getLinkType(RegexResult regexResult) {
        String string = CommandLinkElement.trimAndLowerCase(regexResult.get("HEAD1", 0));
        String string2 = CommandLinkElement.trimAndLowerCase(regexResult.get("HEAD2", 0));
        LinkDecor linkDecor = LinkDecor.NONE;
        LinkDecor linkDecor2 = LinkDecor.NONE;
        if (string.equals("(0")) {
            linkDecor = LinkDecor.CIRCLE_CONNECT;
        } else if (string.equals("#")) {
            linkDecor = LinkDecor.SQUARE;
        } else if (string.equals("0")) {
            linkDecor = LinkDecor.CIRCLE;
        } else if (string.equals("(")) {
            linkDecor = LinkDecor.PARENTHESIS;
        } else if (string.equals(">")) {
            linkDecor = LinkDecor.ARROW;
        } else if (string.equals("*")) {
            linkDecor = LinkDecor.COMPOSITION;
        } else if (string.equals("o")) {
            linkDecor = LinkDecor.AGREGATION;
        } else if (string.equals("+")) {
            linkDecor = LinkDecor.PLUS;
        } else if (string.equals(">>")) {
            linkDecor = LinkDecor.ARROW_TRIANGLE;
        } else if (string.equals("^")) {
            linkDecor = LinkDecor.EXTENDS;
        } else if (string.equals("|>")) {
            linkDecor = LinkDecor.EXTENDS;
        }
        if (string2.equals("0)")) {
            linkDecor2 = LinkDecor.CIRCLE_CONNECT;
        } else if (string2.equals("#")) {
            linkDecor2 = LinkDecor.SQUARE;
        } else if (string2.equals("0")) {
            linkDecor2 = LinkDecor.CIRCLE;
        } else if (string2.equals(")")) {
            linkDecor2 = LinkDecor.PARENTHESIS;
        } else if (string2.equals("<")) {
            linkDecor2 = LinkDecor.ARROW;
        } else if (string2.equals("*")) {
            linkDecor2 = LinkDecor.COMPOSITION;
        } else if (string2.equals("o")) {
            linkDecor2 = LinkDecor.AGREGATION;
        } else if (string2.equals("+")) {
            linkDecor2 = LinkDecor.PLUS;
        } else if (string2.equals("<<")) {
            linkDecor2 = LinkDecor.ARROW_TRIANGLE;
        } else if (string2.equals("^")) {
            linkDecor2 = LinkDecor.EXTENDS;
        } else if (string2.equals("<|")) {
            linkDecor2 = LinkDecor.EXTENDS;
        }
        LinkType linkType = new LinkType(linkDecor, linkDecor2);
        String string3 = this.getQueue(regexResult);
        if (string3.contains(".")) {
            linkType = linkType.getDashed();
        } else if (string3.contains("~")) {
            linkType = linkType.getDotted();
        } else if (string3.contains("=")) {
            linkType = linkType.getBold();
        }
        String string4 = regexResult.get("INSIDE", 0);
        if ("0".equals(string4)) {
            linkType = linkType.withMiddleCircle();
        } else if ("0)".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled1();
        } else if ("(0".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled2();
        } else if ("(0)".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled();
        }
        return linkType;
    }

    private static String trimAndLowerCase(String string) {
        if (string == null) {
            return "";
        }
        return StringUtils.goLowerCase(StringUtils.trin(string));
    }

    private Direction getDirection(RegexResult regexResult) {
        String string = regexResult.get("DIRECTION", 0);
        if (string == null) {
            return StringUtils.getQueueDirection(this.getQueue(regexResult));
        }
        return StringUtils.getQueueDirection(string);
    }

    private String getQueue(RegexResult regexResult) {
        return regexResult.get("BODY1", 0) + regexResult.get("BODY2", 0);
    }

    private static RegexLeaf getGroup(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|(?!\\[\\*\\])\\[[^\\[\\]]+\\]|\\((?!\\*\\))[^)]+\\))");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        Code code = Code.of(regexResult.get("ENT1", 0));
        Code code2 = Code.of(regexResult.get("ENT2", 0));
        if (descriptionDiagram.isGroup(code) && descriptionDiagram.isGroup(code2)) {
            return this.executePackageLink(descriptionDiagram, regexResult);
        }
        ILeaf iLeaf = descriptionDiagram.isGroup(code) ? descriptionDiagram.getGroup(Code.of(regexResult.get("ENT1", 0))) : this.getOrCreateLeaf(descriptionDiagram, code);
        ILeaf iLeaf2 = descriptionDiagram.isGroup(code2) ? descriptionDiagram.getGroup(Code.of(regexResult.get("ENT2", 0))) : this.getOrCreateLeaf(descriptionDiagram, code2);
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        String string = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(regexResult);
        Labels labels = new Labels(regexResult);
        Link link = new Link(iLeaf, iLeaf2, linkType, Display.getWithNewlines(labels.labelLink), string.length(), labels.firstLabel, labels.secondLabel, descriptionDiagram.getLabeldistance(), descriptionDiagram.getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        Colors colors = CommandLinkElement.color().getColor(regexResult, descriptionDiagram.getSkinParam().getIHtmlColorSet());
        colors = CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link, colors);
        if (regexResult.get("STEREOTYPE", 0) != null) {
            Stereotype stereotype = new Stereotype(regexResult.get("STEREOTYPE", 0));
            colors = colors.applyStereotype(stereotype, descriptionDiagram.getSkinParam(), ColorParam.arrow);
        }
        link.setColors(colors);
        descriptionDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private ILeaf getOrCreateLeaf(DescriptionDiagram descriptionDiagram, Code code) {
        char c;
        String string = code.getFullName();
        if (string.startsWith("()")) {
            return descriptionDiagram.getOrCreateLeaf(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(string.substring(2)))), LeafType.DESCRIPTION, USymbol.INTERFACE);
        }
        char c2 = c = string.length() > 2 ? string.charAt(0) : (char)'\u0000';
        if (c == '(') {
            return descriptionDiagram.getOrCreateLeaf(code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.USECASE, USymbol.USECASE);
        }
        if (c == ':') {
            return descriptionDiagram.getOrCreateLeaf(code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, USymbol.ACTOR);
        }
        if (c == '[') {
            USymbol uSymbol = descriptionDiagram.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
            return descriptionDiagram.getOrCreateLeaf(code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, uSymbol);
        }
        return descriptionDiagram.getOrCreateLeaf(code, null, null);
    }

    private CommandExecutionResult executePackageLink(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        IGroup iGroup = descriptionDiagram.getGroup(Code.of(regexResult.get("ENT1", 0)));
        IGroup iGroup2 = descriptionDiagram.getGroup(Code.of(regexResult.get("ENT2", 0)));
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        String string = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(regexResult);
        Link link = new Link(iGroup, iGroup2, linkType, Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)), string.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link);
        descriptionDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static class Labels {
        private String firstLabel;
        private String secondLabel;
        private String labelLink;

        Labels(RegexResult regexResult) {
            this.firstLabel = regexResult.get("LABEL1", 0);
            this.secondLabel = regexResult.get("LABEL2", 0);
            this.labelLink = regexResult.get("LABEL_LINK", 0);
            if (this.labelLink != null) {
                if (this.firstLabel == null && this.secondLabel == null) {
                    this.init();
                }
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.labelLink);
            }
        }

        private void init() {
            Pattern2 pattern2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 matcher2 = pattern2.matcher(this.labelLink);
            if (matcher2.matches()) {
                this.firstLabel = matcher2.group(1);
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher2.group(2))));
                this.secondLabel = matcher2.group(3);
                return;
            }
            Pattern2 pattern22 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
            Matcher2 matcher22 = pattern22.matcher(this.labelLink);
            if (matcher22.matches()) {
                this.firstLabel = matcher22.group(1);
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher22.group(2))));
                this.secondLabel = null;
                return;
            }
            Pattern2 pattern23 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 matcher23 = pattern23.matcher(this.labelLink);
            if (matcher23.matches()) {
                this.firstLabel = null;
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher23.group(1))));
                this.secondLabel = matcher23.group(2);
            }
        }
    }
}

