/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExeState {
    NULL_UNDEFINED,
    OK,
    DOES_NOT_EXIST,
    IS_A_DIRECTORY,
    NOT_A_FILE,
    CANNOT_BE_READ;


    public static ExeState checkFile(File file) {
        if (file == null) {
            return NULL_UNDEFINED;
        }
        if (!file.exists()) {
            return DOES_NOT_EXIST;
        }
        if (file.isDirectory()) {
            return IS_A_DIRECTORY;
        }
        if (!file.isFile()) {
            return NOT_A_FILE;
        }
        if (!file.canRead()) {
            return CANNOT_BE_READ;
        }
        return OK;
    }

    public String getTextMessage() {
        switch (this) {
            case OK: {
                return "File OK";
            }
            case NULL_UNDEFINED: {
                return "No dot executable found";
            }
            case DOES_NOT_EXIST: {
                return "File does not exist";
            }
            case IS_A_DIRECTORY: {
                return "It should be an executable, not a directory";
            }
            case NOT_A_FILE: {
                return "Not a valid file";
            }
            case CANNOT_BE_READ: {
                return "File cannot be read";
            }
        }
        throw new IllegalStateException();
    }

    public String getTextMessage(File file) {
        switch (this) {
            case OK: {
                return "File " + file.getAbsolutePath() + " OK";
            }
            case NULL_UNDEFINED: {
                return NULL_UNDEFINED.getTextMessage();
            }
            case DOES_NOT_EXIST: {
                return "File " + file.getAbsolutePath() + " does not exist";
            }
            case IS_A_DIRECTORY: {
                return "File " + file.getAbsolutePath() + " should be an executable, not a directory";
            }
            case NOT_A_FILE: {
                return "File " + file.getAbsolutePath() + " is not a valid file";
            }
            case CANNOT_BE_READ: {
                return "File " + file.getAbsolutePath() + " cannot be read";
            }
        }
        throw new IllegalStateException();
    }
}

