/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.SvgAttributes;

public class CommandCreoleSvgAttributeChange
implements Command {
    private final Pattern2 pattern;
    public static final String fontPattern = "\\<text[\\s:]+([^>]+)/?\\>";

    public static Command create() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*?)\\</text\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*))$");
    }

    private CommandCreoleSvgAttributeChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        FontConfiguration fontConfiguration;
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration2 = fontConfiguration = stripeSimple.getActualFontConfiguration();
        if (matcher2.group(2) != null) {
            fontConfiguration2 = fontConfiguration2.changeAttributes(new SvgAttributes(matcher2.group(2)));
        }
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher2.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }
}

