/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleImg
implements Command {
    private final Pattern2 pattern;

    private CommandCreoleImg(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public static Command create() {
        return new CommandCreoleImg("^(?i)(\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        String string2 = matcher2.group(2);
        double d = CommandCreoleImg.getScale(matcher2.group(3));
        if (string2.toLowerCase().startsWith("src=")) {
            string2 = string2.substring(4);
        }
        string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2, "\"");
        stripeSimple.addImage(string2, d);
        return string.substring(matcher2.group(1).length());
    }

    public static double getScale(String string) {
        if (string == null) {
            return 1.0;
        }
        Pattern pattern = Pattern.compile("scale=([0-9.]+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return Double.parseDouble(matcher.group(1));
        }
        return 1.0;
    }
}

