/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomTable
implements Atom {
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<Atom, Position> positions = new HashMap<Atom, Position>();
    private final HtmlColor lineColor;

    public AtomTable(HtmlColor htmlColor) {
        this.lineColor = htmlColor;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        double d = this.getEndingX(this.getNbCols() - 1);
        double d2 = this.getEndingY(this.getNbLines() - 1);
        return new Dimension2DDouble(d, d2);
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public void drawU(UGraphic uGraphic) {
        int n;
        this.initMap(uGraphic.getStringBounder());
        for (int i = 0; i < this.getNbLines(); ++i) {
            double d;
            double d2;
            Line line = this.lines.get(i);
            if (line.lineBackColor != null) {
                double d3 = this.getStartingY(i);
                double d4 = this.getStartingY(i + 1);
                d2 = this.getStartingX(0);
                d = this.getStartingX(this.getNbCols());
                uGraphic.apply(new UChangeColor(null)).apply(new UChangeBackColor(line.lineBackColor)).apply(new UTranslate(d2, d3)).draw(new URectangle(d - d2, d4 - d3));
            }
            for (n = 0; n < this.getNbCols(); ++n) {
                double d5;
                if (n >= line.cells.size()) continue;
                Atom atom = (Atom)line.cells.get(n);
                HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
                if (atom instanceof SheetBlock1) {
                    horizontalAlignment = ((SheetBlock1)atom).getCellAlignment();
                }
                HtmlColor htmlColor = (HtmlColor)line.cellsBackColor.get(n);
                d2 = this.getStartingX(n);
                d = this.getStartingX(n + 1);
                double d6 = d - d2;
                if (htmlColor != null) {
                    double d7 = this.getStartingY(i);
                    d5 = this.getStartingY(i + 1);
                    uGraphic.apply(new UChangeColor(null)).apply(new UChangeBackColor(htmlColor)).apply(new UTranslate(d2, d7)).draw(new URectangle(d - d2, d5 - d7));
                }
                Position position = this.positions.get(atom);
                Dimension2D dimension2D = atom.calculateDimension(uGraphic.getStringBounder());
                d5 = horizontalAlignment == HorizontalAlignment.RIGHT ? d6 - dimension2D.getWidth() : 0.0;
                atom.drawU(uGraphic.apply(position.getTranslate().compose(new UTranslate(d5, 0.0))));
            }
        }
        uGraphic = uGraphic.apply(new UChangeColor(this.lineColor));
        ULine uLine = new ULine(this.getEndingX(this.getNbCols() - 1), 0.0);
        for (int i = 0; i <= this.getNbLines(); ++i) {
            uGraphic.apply(new UTranslate(0.0, this.getStartingY(i))).draw(uLine);
        }
        ULine uLine2 = new ULine(0.0, this.getEndingY(this.getNbLines() - 1));
        for (n = 0; n <= this.getNbCols(); ++n) {
            uGraphic.apply(new UTranslate(this.getStartingX(n), 0.0)).draw(uLine2);
        }
    }

    private void initMap(StringBounder stringBounder) {
        if (this.positions.size() > 0) {
            return;
        }
        for (Line line : this.lines) {
            for (Object object : line.cells) {
                Dimension2D dimension2D = object.calculateDimension(stringBounder);
                Position position = new Position(0.0, 0.0, dimension2D);
                this.positions.put((Atom)object, position);
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int j = 0; j < this.lines.get(i).size(); ++j) {
                Object object;
                Atom atom = (Atom)this.lines.get(i).cells.get(j);
                object = atom.calculateDimension(stringBounder);
                double d = this.getStartingX(j);
                double d2 = this.getStartingY(i);
                Position position = new Position(d, d2, (Dimension2D)object);
                this.positions.put(atom, position);
            }
        }
    }

    private double getStartingX(int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.getColWidth(i);
        }
        return d;
    }

    private double getEndingX(int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += this.getColWidth(i);
        }
        return d;
    }

    private double getStartingY(int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.getLineHeight(i);
        }
        return d;
    }

    private double getEndingY(int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += this.getLineHeight(i);
        }
        return d;
    }

    private double getColWidth(int n) {
        double d = 0.0;
        for (int i = 0; i < this.getNbLines(); ++i) {
            Position position = this.getPosition(i, n);
            if (position == null) continue;
            double d2 = position.getWidth();
            d = Math.max(d, d2);
        }
        return d;
    }

    private double getLineHeight(int n) {
        double d = 0.0;
        for (int i = 0; i < this.getNbCols(); ++i) {
            Position position = this.getPosition(n, i);
            if (position == null) continue;
            double d2 = position.getHeight();
            d = Math.max(d, d2);
        }
        return d;
    }

    private Position getPosition(int n, int n2) {
        if (n >= this.lines.size()) {
            return null;
        }
        Line line = this.lines.get(n);
        if (n2 >= line.cells.size()) {
            return null;
        }
        Atom atom = (Atom)line.cells.get(n2);
        return this.positions.get(atom);
    }

    private int getNbCols() {
        return this.lines.get(0).size();
    }

    private int getNbLines() {
        return this.lines.size();
    }

    private Line lastLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public void addCell(Atom atom, HtmlColor htmlColor) {
        this.lastLine().add(atom, htmlColor);
        this.positions.clear();
    }

    public void newLine(HtmlColor htmlColor) {
        this.lines.add(new Line(htmlColor));
    }

    class Line {
        private final List<Atom> cells = new ArrayList<Atom>();
        private final List<HtmlColor> cellsBackColor = new ArrayList<HtmlColor>();
        private final HtmlColor lineBackColor;

        private Line(HtmlColor htmlColor) {
            this.lineBackColor = htmlColor;
        }

        public void add(Atom atom, HtmlColor htmlColor) {
            this.cells.add(atom);
            this.cellsBackColor.add(htmlColor);
        }

        public int size() {
            return this.cells.size();
        }

        public String toString() {
            return super.toString() + " " + this.cells.size();
        }
    }
}

