/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryTipOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryTipOnEntityCommand(IRegex iRegex) {
        this.partialPattern = iRegex;
    }

    private RegexConcat getRegexConcatMultiLine(IRegex iRegex, boolean bl) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left)"), new RegexLeaf("[%s]+of[%s]+"), iRegex, new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf(bl ? "[%s]*\\{" : "[%s]*"), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean bl) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern, bl), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                if (bl) {
                    return "(?i)^(\\})$";
                }
                return "(?i)^[%s]*(end[%s]?note)$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram abstractEntityDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                Url url = null;
                if (regexResult.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(regexResult.get("URL", 0));
                }
                return FactoryTipOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, url, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult regexResult, AbstractEntityDiagram abstractEntityDiagram, Url url, BlocLines blocLines) {
        String string = regexResult.get("POSITION", 0);
        Code code = Code.of(regexResult.get("ENTITY", 0));
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENTITY", 1));
        if (code == null) {
            return CommandExecutionResult.error("Nothing to note to");
        }
        IEntity iEntity = abstractEntityDiagram.getOrCreateLeaf(code, null, null);
        Position position = Position.valueOf(StringUtils.goUpperCase(string)).withRankdir(abstractEntityDiagram.getSkinParam().getRankdir());
        Code code2 = code.addSuffix("$$$" + position.name());
        IEntity iEntity2 = abstractEntityDiagram.getLeafsget(code2);
        if (iEntity2 == null) {
            iEntity2 = abstractEntityDiagram.getOrCreateLeaf(code2, LeafType.TIPS, null);
            LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
            Link link = position == Position.RIGHT ? new Link(iEntity, iEntity2, linkType, Display.NULL, 1) : new Link(iEntity2, iEntity, linkType, Display.NULL, 1);
            abstractEntityDiagram.addLink(link);
        }
        iEntity2.putTip(string2, blocLines.toDisplay());
        return CommandExecutionResult.ok();
    }
}

