/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MultilinesStrategy {
    REMOVE_STARTING_QUOTE,
    KEEP_STARTING_QUOTE;


    public void cleanList(List<? extends CharSequence> list) {
        if (this == REMOVE_STARTING_QUOTE) {
            this.filterQuote(list);
        }
    }

    private void filterQuote(List<? extends CharSequence> list) {
        Iterator<? extends CharSequence> iterator = list.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = iterator.next();
            if (!this.hasStartingQuote(charSequence)) continue;
            iterator.remove();
        }
    }

    private boolean hasStartingQuote(CharSequence charSequence) {
        return StringUtils.trinNoTrace(charSequence).startsWith("'");
    }
}

