/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandDecoratorMultine<D extends Diagram>
implements Command<D> {
    private final SingleLineCommand2<D> cmd;
    private final boolean removeEmptyColumn;
    private final int nbMaxLines;

    public CommandDecoratorMultine(SingleLineCommand2<D> singleLineCommand2, int n) {
        this(singleLineCommand2, false, n);
    }

    public CommandDecoratorMultine(SingleLineCommand2<D> singleLineCommand2, boolean bl, int n) {
        this.cmd = singleLineCommand2;
        this.removeEmptyColumn = bl;
        this.nbMaxLines = n;
    }

    @Override
    public CommandExecutionResult execute(D d, BlocLines blocLines) {
        if (this.removeEmptyColumn) {
            blocLines = blocLines.removeEmptyColumns();
        }
        blocLines = blocLines.toSingleLineWithHiddenNewLine();
        return this.cmd.execute(d, blocLines);
    }

    @Override
    public CommandControl isValid(BlocLines blocLines) {
        if (this.cmd.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        if (this.cmd.isForbidden((blocLines = blocLines.toSingleLineWithHiddenNewLine()).getFirst499())) {
            return CommandControl.NOT_OK;
        }
        CommandControl commandControl = this.cmd.isValid(blocLines);
        if (commandControl == CommandControl.OK_PARTIAL) {
            throw new IllegalStateException();
        }
        if (commandControl == CommandControl.OK) {
            return commandControl;
        }
        return CommandControl.OK_PARTIAL;
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }

    public int getNbMaxLines() {
        return this.nbMaxLines;
    }
}

