/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlocLines
implements Iterable<CharSequence> {
    private List<CharSequence> lines;

    public String toString() {
        return this.lines.toString();
    }

    private BlocLines(List<? extends CharSequence> list) {
        this.lines = Collections.unmodifiableList(list);
    }

    public Display toDisplay() {
        return Display.create(this.lines);
    }

    public static BlocLines single(CharSequence charSequence) {
        return new BlocLines(Arrays.asList(charSequence));
    }

    public static BlocLines getWithNewlines(CharSequence charSequence) {
        return new BlocLines(BackSlash.getWithNewlines(charSequence));
    }

    public BlocLines() {
        this(new ArrayList());
    }

    public BlocLines add2(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        arrayList.add(charSequence);
        return new BlocLines(arrayList);
    }

    public List<CharSequence> getLines() {
        return this.lines;
    }

    public int size() {
        return this.lines.size();
    }

    public CharSequence get499(int n) {
        return this.lines.get(n);
    }

    public CharSequence getFirst499() {
        return this.lines.get(0);
    }

    public CharSequence getLast499() {
        return this.lines.get(this.lines.size() - 1);
    }

    public BlocLines cleanList2(MultilinesStrategy multilinesStrategy) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        multilinesStrategy.cleanList(arrayList);
        return new BlocLines(arrayList);
    }

    public BlocLines trim(boolean bl) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        for (int i = 0; i < arrayList.size(); ++i) {
            CharSequence charSequence = (CharSequence)arrayList.get(i);
            arrayList.set(i, StringUtils.trin(charSequence));
        }
        if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (((CharSequence)iterator.next()).length() != 0) continue;
                iterator.remove();
            }
        }
        return new BlocLines(arrayList);
    }

    public BlocLines removeEmptyColumns() {
        if (!BlocLines.firstColumnRemovable(this.lines)) {
            return this;
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        do {
            for (int i = 0; i < arrayList.size(); ++i) {
                CharSequence charSequence = (CharSequence)arrayList.get(i);
                if (charSequence.length() <= 0) continue;
                arrayList.set(i, charSequence.subSequence(1, charSequence.length()));
            }
        } while (BlocLines.firstColumnRemovable(arrayList));
        return new BlocLines(arrayList);
    }

    private static boolean firstColumnRemovable(List<CharSequence> list) {
        boolean bl = true;
        for (CharSequence charSequence : list) {
            if (charSequence.length() == 0) continue;
            bl = false;
            char c = charSequence.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !bl;
    }

    public char getLastChar() {
        CharSequence charSequence = this.lines.get(this.lines.size() - 1);
        return charSequence.charAt(charSequence.length() - 1);
    }

    public BlocLines removeStartingAndEnding2(String string) {
        if (this.lines.size() == 0) {
            return this;
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        arrayList.set(0, string);
        int n = arrayList.size() - 1;
        CharSequence charSequence = (CharSequence)arrayList.get(n);
        arrayList.set(n, charSequence.subSequence(0, charSequence.length() - 1));
        return new BlocLines(arrayList);
    }

    public BlocLines toSingleLineWithHiddenNewLine() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : this.lines) {
            stringBuilder.append(charSequence);
            stringBuilder.append(BackSlash.hiddenNewLine());
        }
        return BlocLines.single(stringBuilder.substring(0, stringBuilder.length() - 1));
    }

    public BlocLines trimSmart(int n) {
        if (this.lines.size() <= n) {
            return this;
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(this.lines);
        int n2 = BlocLines.nbStartingSpace((CharSequence)arrayList.get(n));
        for (int i = n; i < arrayList.size(); ++i) {
            CharSequence charSequence = (CharSequence)arrayList.get(i);
            arrayList.set(i, BlocLines.removeStartingSpaces(charSequence, n2));
        }
        return new BlocLines(arrayList);
    }

    private static int nbStartingSpace(CharSequence charSequence) {
        int n;
        for (n = 0; n < charSequence.length() && BlocLines.isSpaceOrTab(charSequence.charAt(n)); ++n) {
        }
        return n;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static CharSequence removeStartingSpaces(CharSequence charSequence, int n) {
        int n2;
        if (charSequence.length() == 0) {
            return charSequence;
        }
        for (n2 = 0; n2 < n && n2 < charSequence.length() && BlocLines.isSpaceOrTab(charSequence.charAt(n2)); ++n2) {
        }
        if (n2 == 0) {
            return charSequence;
        }
        return charSequence.subSequence(n2, charSequence.length());
    }

    public BlocLines subExtract(int n, int n2) {
        List<CharSequence> list = new ArrayList<CharSequence>(this.lines);
        list = list.subList(n, list.size() - n2);
        return new BlocLines(list);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return this.lines.iterator();
    }

    public BlocLines removeComments() {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        boolean bl = false;
        for (CharSequence charSequence : this.lines) {
            if (!bl && MyPattern.mtches(charSequence, "(?i)^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$")) continue;
            if (!bl && MyPattern.mtches(charSequence, "(?i)^[%s]*/[%q]([^%q]|[%q][^/])*$")) {
                bl = true;
                continue;
            }
            if (bl && MyPattern.mtches(charSequence, "(?i)^([^%q]|[%q][^/])*[%q]/[%s]*$")) {
                bl = false;
                continue;
            }
            if (bl) continue;
            arrayList.add(charSequence);
        }
        return new BlocLines(arrayList);
    }

    public BlocLines removeInnerComments() {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (CharSequence charSequence : this.lines) {
            arrayList.add(MyPattern.removeAll(charSequence, "/[%q].*?[%q]/"));
        }
        return new BlocLines(arrayList);
    }
}

