/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileIfWithDiamonds
extends FtileIfNude {
    private final double SUPP_WITH = 20.0;
    protected final Ftile diamond1;
    protected final Ftile diamond2;

    public FtileIfWithDiamonds(Ftile ftile, Ftile ftile2, Ftile ftile3, Ftile ftile4, Swimlane swimlane, StringBounder stringBounder) {
        super(ftile2, ftile3, swimlane);
        this.diamond1 = ftile;
        this.diamond2 = ftile4;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.diamond1, this.diamond2, this.tile1, this.tile2);
    }

    public int getYdelta1a(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 20;
        }
        return 10;
    }

    public int getYdelta1b(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 10;
        }
        return this.hasTwoBranches(stringBounder) ? 6 : 0;
    }

    @Override
    protected double withInner(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        return Math.max(super.withInner(stringBounder), ftileGeometry.getWidth() + 20.0);
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = super.calculateDimensionInternalSlow(stringBounder);
        FtileGeometry ftileGeometry4 = ftileGeometry.appendBottom(ftileGeometry3).appendBottom(ftileGeometry2);
        return ftileGeometry4.addDim(0.0, this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder));
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        super.drawU(uGraphic);
        uGraphic.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    protected UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate1(stringBounder).compose(new UTranslate(0.0, ftileGeometry.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    @Override
    protected UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate2(stringBounder).compose(new UTranslate(0.0, ftileGeometry.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        double d = ftileGeometry.getLeft() - ftileGeometry2.getLeft();
        return new UTranslate(d, 0.0);
    }

    protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        double d = ftileGeometry.getHeight() - ftileGeometry2.getHeight();
        double d2 = ftileGeometry.getLeft() - ftileGeometry2.getWidth() / 2.0;
        return new UTranslate(d2, d);
    }

    public double computeMarginNeedForBranchLabe1(StringBounder stringBounder, Dimension2D dimension2D) {
        double d;
        double d2 = dimension2D.getWidth();
        double d3 = d2 - (d = this.getTranslateDiamond1(stringBounder).getDx());
        if (d3 > 0.0) {
            return d3;
        }
        return 0.0;
    }

    public double computeMarginNeedForBranchLabe2(StringBounder stringBounder, Dimension2D dimension2D) {
        double d = dimension2D.getWidth();
        double d2 = this.getTranslateDiamond1(stringBounder).getDx() + this.diamond1.calculateDimension(stringBounder).getWidth() + d;
        double d3 = d2 - this.calculateDimension(stringBounder).getWidth();
        if (d3 > 0.0) {
            return d3;
        }
        return 0.0;
    }

    public double computeVerticalMarginNeedForBranchs(StringBounder stringBounder, Dimension2D dimension2D, Dimension2D dimension2D2) {
        FtileGeometry ftileGeometry;
        double d;
        double d2 = Math.max(dimension2D.getHeight(), dimension2D2.getHeight());
        double d3 = d2 - (d = (ftileGeometry = this.diamond1.calculateDimension(stringBounder)).getHeight());
        if (d3 > 0.0) {
            return d3;
        }
        return 0.0;
    }
}

