/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileSplit1
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileSplit1(List<Ftile> list) {
        super(list.get(0).skinParam());
        for (Ftile ftile : list) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return null;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileSplit1.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Ftile ftile : list) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Ftile ftile : this.forks) {
            uGraphic.apply(this.getTranslateFor(ftile, stringBounder)).draw(ftile);
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Ftile ftile : this.forks) {
            FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
            if (((Dimension2D)ftileGeometry).getWidth() > d2) {
                d2 = ((Dimension2D)ftileGeometry).getWidth();
            }
            if (!(((Dimension2D)ftileGeometry).getHeight() > d)) continue;
            d = ((Dimension2D)ftileGeometry).getHeight();
        }
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d2, d);
        return new FtileGeometry(dimension2DDouble, ((Dimension2D)dimension2DDouble).getWidth() / 2.0, 0.0, ((Dimension2D)dimension2DDouble).getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
        double d = this.calculateDimension(stringBounder).getWidth() - ((Dimension2D)ftileGeometry).getWidth();
        return new UTranslate(d / 2.0, 0.0);
    }
}

