/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.activitydiagram3.ftile.WormMutation;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snake
implements UShape {
    private final Worm worm = new Worm();
    private UPolygon endDecoration;
    private final Rainbow color;
    private TextBlock textBlock;
    private MergeStrategy mergeable = MergeStrategy.FULL;
    private Direction emphasizeDirection;
    private final HorizontalAlignment horizontalAlignment;

    public Snake transformX(CompressionTransform compressionTransform) {
        Snake snake = new Snake(this.horizontalAlignment, this.color, this.endDecoration);
        snake.textBlock = this.textBlock;
        snake.mergeable = this.mergeable;
        snake.emphasizeDirection = this.emphasizeDirection;
        for (Point2D.Double double_ : this.worm) {
            double d = compressionTransform.transform(double_.x);
            double d2 = double_.y;
            snake.addPoint(d, d2);
        }
        return snake;
    }

    public void removeEndDecoration() {
        this.endDecoration = null;
    }

    public Snake(HorizontalAlignment horizontalAlignment, Rainbow rainbow, UPolygon uPolygon) {
        if (rainbow == null) {
            throw new IllegalArgumentException();
        }
        if (rainbow.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.endDecoration = uPolygon;
        this.color = rainbow;
        this.horizontalAlignment = horizontalAlignment;
    }

    public Snake(HorizontalAlignment horizontalAlignment, Rainbow rainbow) {
        this(horizontalAlignment, rainbow, null);
    }

    public void setLabel(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public Snake move(double d, double d2) {
        Snake snake = new Snake(this.horizontalAlignment, this.color, this.endDecoration);
        for (Point2D point2D : this.worm) {
            snake.addPoint(point2D.getX() + d, point2D.getY() + d2);
        }
        snake.textBlock = this.textBlock;
        snake.mergeable = this.mergeable;
        snake.emphasizeDirection = this.emphasizeDirection;
        return snake;
    }

    public Snake translate(UTranslate uTranslate) {
        return this.move(uTranslate.getDx(), uTranslate.getDy());
    }

    public String toString() {
        return this.worm.toString();
    }

    public void addPoint(double d, double d2) {
        this.worm.addPoint(d, d2);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void drawInternal(UGraphic uGraphic) {
        if (this.color.size() > 1) {
            this.drawRainbow(uGraphic);
        } else {
            this.worm.drawInternalOneColor(uGraphic, this.color.getColors().get(0), 1.5, this.emphasizeDirection, this.endDecoration);
            this.drawInternalLabel(uGraphic);
        }
    }

    private void drawRainbow(UGraphic uGraphic) {
        List<HtmlColorAndStyle> list = this.color.getColors();
        int n = this.color.getColorArrowSeparationSpace();
        double d = 2 + n;
        WormMutation wormMutation = WormMutation.create(this.worm, d);
        double d2 = -1.0 * (double)(list.size() - 1) / 2.0;
        Worm worm = this.worm.moveFirstPoint(wormMutation.getFirst().multiplyBy(d2));
        if (wormMutation.size() > 2) {
            worm = worm.moveLastPoint(wormMutation.getLast().multiplyBy(d2));
        }
        for (int i = 0; i < list.size(); ++i) {
            double d3 = 1.5;
            if (n == 0) {
                d3 = i == list.size() - 1 ? 2.0 : 3.0;
            }
            worm.drawInternalOneColor(uGraphic, list.get(i), d3, this.emphasizeDirection, this.endDecoration);
            worm = wormMutation.mute(worm);
        }
        UTranslate uTranslate = wormMutation.getTextTranslate(list.size());
        this.drawInternalLabel(uGraphic.apply(uTranslate));
    }

    private void drawInternalLabel(UGraphic uGraphic) {
        if (this.textBlock != null) {
            Point2D point2D = this.getTextBlockPosition(uGraphic.getStringBounder());
            this.textBlock.drawU(uGraphic.apply(new UTranslate(point2D)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (Cloneable cloneable : this.worm) {
            d = Math.max(d, ((Point2D)cloneable).getX());
        }
        if (this.textBlock != null) {
            Cloneable cloneable;
            Point2D point2D = this.getTextBlockPosition(stringBounder);
            cloneable = this.textBlock.calculateDimension(stringBounder);
            d = Math.max(d, point2D.getX() + ((Dimension2D)cloneable).getWidth());
        }
        return d;
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        boolean bl;
        Point2D.Double double_ = this.worm.get(0);
        Point2D.Double double_2 = this.worm.get(1);
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        double d = Math.max(((Point2D)double_).getX(), ((Point2D)double_2).getX()) + 4.0;
        boolean bl2 = bl = this.worm.getDirectionsCode().startsWith("DLD") || this.worm.getDirectionsCode().startsWith("DRD");
        if (this.horizontalAlignment == HorizontalAlignment.CENTER && bl) {
            Point2D.Double double_3 = this.worm.get(2);
            d = (((Point2D)double_2).getX() + ((Point2D)double_3).getX()) / 2.0 - dimension2D.getWidth() / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT && bl) {
            d = Math.max(((Point2D)double_).getX(), ((Point2D)double_2).getX()) - dimension2D.getWidth() - 4.0;
        }
        double d2 = (((Point2D)double_).getY() + ((Point2D)double_2).getY()) / 2.0 - dimension2D.getHeight() / 2.0;
        return new Point2D.Double(d, d2);
    }

    public List<Line2D> getHorizontalLines() {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (int i = 0; i < this.worm.size() - 1; ++i) {
            Point2D.Double double_ = this.worm.get(i);
            Point2D.Double double_2 = this.worm.get(i + 1);
            if (((Point2D)double_).getY() != ((Point2D)double_2).getY()) continue;
            Line2D.Double double_3 = new Line2D.Double(double_, double_2);
            arrayList.add(double_3);
        }
        return arrayList;
    }

    private Point2D getFirst() {
        return this.worm.get(0);
    }

    public Point2D getLast() {
        return this.worm.get(this.worm.size() - 1);
    }

    static boolean same(Point2D point2D, Point2D point2D2) {
        return point2D.distance(point2D2) < 0.001;
    }

    public Snake merge(Snake snake, StringBounder stringBounder) {
        MergeStrategy mergeStrategy = this.mergeable.max(snake.mergeable);
        if (mergeStrategy == MergeStrategy.NONE) {
            return null;
        }
        boolean bl = TextBlockUtils.isEmpty(snake.textBlock, stringBounder);
        if (!bl) {
            return null;
        }
        if (Snake.same(this.getLast(), snake.getFirst())) {
            UPolygon uPolygon = snake.endDecoration == null ? this.endDecoration : snake.endDecoration;
            Snake snake2 = new Snake(this.horizontalAlignment, this.color, uPolygon);
            snake2.emphasizeDirection = this.emphasizeDirection == null ? snake.emphasizeDirection : this.emphasizeDirection;
            snake2.worm.addAll(this.worm.merge(snake.worm, mergeStrategy));
            snake2.mergeable = mergeStrategy;
            return snake2;
        }
        if (Snake.same(this.getFirst(), snake.getLast())) {
            return snake.merge(this, stringBounder);
        }
        return null;
    }

    public boolean touches(Snake snake) {
        if (snake.mergeable != MergeStrategy.FULL) {
            return false;
        }
        if (snake.worm.isPureHorizontal()) {
            return false;
        }
        return Snake.same(this.getLast(), snake.getFirst());
    }

    public void goUnmergeable(MergeStrategy mergeStrategy) {
        this.mergeable = mergeStrategy;
    }

    public void emphasizeDirection(Direction direction) {
        this.emphasizeDirection = direction;
    }
}

