/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BoxStyle {
    PLAIN{

        protected Shadowable getShape(double d, double d2) {
            return new URectangle(d, d2, 25.0, 25.0);
        }
    }
    ,
    SDL_INPUT('<'){

        protected Shadowable getShape(double d, double d2) {
            UPolygon uPolygon = new UPolygon();
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(d + (double)DELTA_INPUT_OUTPUT, 0.0);
            uPolygon.addPoint(d, d2 / 2.0);
            uPolygon.addPoint(d + (double)DELTA_INPUT_OUTPUT, d2);
            uPolygon.addPoint(0.0, d2);
            return uPolygon;
        }
    }
    ,
    SDL_OUTPUT('>'){

        protected Shadowable getShape(double d, double d2) {
            UPolygon uPolygon = new UPolygon();
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(d, 0.0);
            uPolygon.addPoint(d + (double)DELTA_INPUT_OUTPUT, d2 / 2.0);
            uPolygon.addPoint(d, d2);
            uPolygon.addPoint(0.0, d2);
            return uPolygon;
        }
    }
    ,
    SDL_PROCEDURE('|'){

        protected void drawInternal(UGraphic uGraphic, double d, double d2, boolean bl) {
            URectangle uRectangle = new URectangle(d, d2);
            if (bl) {
                uRectangle.setDeltaShadow(3.0);
            }
            uGraphic.draw(uRectangle);
            ULine uLine = new ULine(0.0, d2);
            uGraphic.apply(new UTranslate(PADDING, 0.0)).draw(uLine);
            uGraphic.apply(new UTranslate(d - (double)PADDING, 0.0)).draw(uLine);
        }
    }
    ,
    SDL_SAVE('\\'){

        protected Shadowable getShape(double d, double d2) {
            UPolygon uPolygon = new UPolygon();
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(d - (double)DELTA_INPUT_OUTPUT, 0.0);
            uPolygon.addPoint(d, d2);
            uPolygon.addPoint(DELTA_INPUT_OUTPUT, d2);
            return uPolygon;
        }
    }
    ,
    SDL_ANTISAVE('/'){

        protected Shadowable getShape(double d, double d2) {
            UPolygon uPolygon = new UPolygon();
            uPolygon.addPoint(DELTA_INPUT_OUTPUT, 0.0);
            uPolygon.addPoint(d, 0.0);
            uPolygon.addPoint(d - (double)DELTA_INPUT_OUTPUT, d2);
            uPolygon.addPoint(0.0, d2);
            return uPolygon;
        }
    }
    ,
    SDL_CONTINUOUS('}'){

        protected Shadowable getShape(double d, double d2) {
            UPath uPath = new UPath();
            double[] dArray = new double[]{DELTA_CONTINUOUS, 0.0};
            double[] dArray2 = new double[]{0.0, d2 / 2.0};
            double[] dArray3 = new double[]{DELTA_CONTINUOUS, d2};
            uPath.add(dArray, USegmentType.SEG_MOVETO);
            uPath.add(dArray2, USegmentType.SEG_LINETO);
            uPath.add(dArray3, USegmentType.SEG_LINETO);
            double[] dArray4 = new double[]{d - DELTA_CONTINUOUS, 0.0};
            double[] dArray5 = new double[]{d, d2 / 2.0};
            double[] dArray6 = new double[]{d - DELTA_CONTINUOUS, d2};
            uPath.add(dArray4, USegmentType.SEG_MOVETO);
            uPath.add(dArray5, USegmentType.SEG_LINETO);
            uPath.add(dArray6, USegmentType.SEG_LINETO);
            return uPath;
        }
    }
    ,
    SDL_TASK(']'){

        protected Shadowable getShape(double d, double d2) {
            return new URectangle(d, d2);
        }
    };

    private static final int CORNER = 25;
    private final char style;
    private static int DELTA_INPUT_OUTPUT;
    private static double DELTA_CONTINUOUS;
    private static int PADDING;

    private BoxStyle() {
        this('\u0000');
    }

    private BoxStyle(char c) {
        this.style = c;
    }

    public static BoxStyle fromChar(char c) {
        for (BoxStyle boxStyle : BoxStyle.values()) {
            if (boxStyle.style != c) continue;
            return boxStyle;
        }
        return PLAIN;
    }

    public final UDrawable getUDrawable(final double d, final double d2, final boolean bl) {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                BoxStyle.this.drawInternal(uGraphic, d, d2, bl);
            }
        };
    }

    protected Shadowable getShape(double d, double d2) {
        return null;
    }

    protected void drawInternal(UGraphic uGraphic, double d, double d2, boolean bl) {
        Shadowable shadowable = this.getShape(d, d2);
        if (bl) {
            shadowable.setDeltaShadow(3.0);
        }
        uGraphic.draw(shadowable);
    }

    static {
        DELTA_INPUT_OUTPUT = 10;
        DELTA_CONTINUOUS = 5.0;
        PADDING = 5;
    }
}

