/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.FileFormat;

public class SuggestedFile {
    private final FileFormat fileFormat;
    private final int initialCpt;
    private final File outputFile;

    private SuggestedFile(File file, FileFormat fileFormat, int n) {
        if (file.getName().endsWith(fileFormat.getFileSuffix())) {
            throw new IllegalArgumentException();
        }
        this.outputFile = file;
        this.fileFormat = fileFormat;
        this.initialCpt = n;
    }

    public String toString() {
        return this.outputFile.getAbsolutePath() + "[" + this.initialCpt + "]";
    }

    public static SuggestedFile fromOutputFile(File file, FileFormat fileFormat) {
        return SuggestedFile.fromOutputFile(file, fileFormat, 0);
    }

    public File getParentFile() {
        return this.outputFile.getParentFile();
    }

    public String getName() {
        return this.outputFile.getName();
    }

    public File getFile(int n) {
        String string = this.fileFormat.changeName(this.outputFile.getName(), this.initialCpt + n);
        return new File(this.outputFile.getParentFile(), string);
    }

    public static SuggestedFile fromOutputFile(File file, FileFormat fileFormat, int n) {
        return new SuggestedFile(file, fileFormat, n);
    }

    public File getTmpFile() {
        return new File(this.getParentFile(), this.getName() + ".tmp");
    }
}

