/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PaddingParam;
import net.sourceforge.plantuml.SplitParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.ColorMapperReverse;
import net.sourceforge.plantuml.ugraphic.ColorOrder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinParam
implements ISkinParam {
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern2 stereoPattern = MyPattern.cmpile("\\<\\<(.*?)\\>\\>");
    private final Map<String, String> params = new HashMap<String, String>();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private String dotExecutable;
    private final UmlDiagramType type;
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private final IHtmlColorSet htmlColorSet = new HtmlColorSetSimple();

    @Override
    public String getDotExecutable() {
        return this.dotExecutable;
    }

    public void setDotExecutable(String string) {
        Log.info("Overwritting dot in skinparam " + string);
        this.dotExecutable = string;
    }

    public void setParam(String string, String string2) {
        this.params.put(SkinParam.cleanForKey(string), StringUtils.trin(string2));
    }

    private SkinParam(UmlDiagramType umlDiagramType) {
        this.type = umlDiagramType;
    }

    public static SkinParam create(UmlDiagramType umlDiagramType) {
        return new SkinParam(umlDiagramType);
    }

    public static SkinParam noShadowing(UmlDiagramType umlDiagramType) {
        SkinParam skinParam = new SkinParam(umlDiagramType);
        skinParam.setParam("shadowing", "false");
        return skinParam;
    }

    static String cleanForKey(String string) {
        string = StringUtils.trin(StringUtils.goLowerCase(string));
        string = string.replaceAll("_|\\.|\\s", "");
        string = SkinParam.replaceSmart(string, "sequenceparticipant", "participant");
        string = SkinParam.replaceSmart(string, "sequenceactor", "actor");
        string = string.replaceAll("activityarrow", "arrow");
        string = string.replaceAll("objectarrow", "arrow");
        string = string.replaceAll("classarrow", "arrow");
        string = string.replaceAll("componentarrow", "arrow");
        string = string.replaceAll("statearrow", "arrow");
        string = string.replaceAll("usecasearrow", "arrow");
        Matcher2 matcher2 = stereoPattern.matcher(string = string.replaceAll("sequencearrow", "arrow"));
        if (matcher2.find()) {
            String string2 = matcher2.group(1);
            string = string.replaceAll(stereoPatternString, "");
            string = string + "<<" + string2 + ">>";
        }
        return string;
    }

    private static String replaceSmart(String string, String string2, String string3) {
        if (!string.contains(string2)) {
            return string;
        }
        return string.replaceAll(string2, string3);
    }

    @Override
    public HtmlColor getHyperlinkColor() {
        HtmlColor htmlColor = this.getHtmlColor(ColorParam.hyperlink, null, false);
        if (htmlColor == null) {
            return HtmlColorUtils.BLUE;
        }
        return htmlColor;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        HtmlColor htmlColor = this.getHtmlColor(ColorParam.background, null, false);
        if (htmlColor == null) {
            return HtmlColorUtils.WHITE;
        }
        return htmlColor;
    }

    @Override
    public String getValue(String string) {
        return this.params.get(SkinParam.cleanForKey(string));
    }

    static String humanName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            stringBuilder.append(bl ? StringUtils.goUpperCase(c) : StringUtils.goLowerCase(c));
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam colorParam, Stereotype stereotype, boolean bl) {
        Object object;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            object = stereotype.getMultipleLabels().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = this.getValue(colorParam.name() + "color<<" + string + ">>");
                if (string2 == null || this.getIHtmlColorSet().getColorIfValid(string2) == null) continue;
                return this.getIHtmlColorSet().getColorIfValid(string2);
            }
        }
        if ((object = this.getValue(this.getParamName(colorParam, bl))) == null) {
            return null;
        }
        boolean bl2 = colorParam == ColorParam.background || colorParam == ColorParam.sequenceGroupBodyBackground;
        return this.getIHtmlColorSet().getColorIfValid((String)object, bl2);
    }

    @Override
    public Colors getColors(ColorParam colorParam, Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue(colorParam.name() + "color" + stereotype.getLabel(false));
            if (string != null && this.getIHtmlColorSet().getColorIfValid(string) != null) {
                return new Colors(string, this.getIHtmlColorSet(), colorParam.getColorType());
            }
        }
        if ((string = this.getValue(this.getParamName(colorParam, false))) == null) {
            return Colors.empty();
        }
        return new Colors(string, this.getIHtmlColorSet(), colorParam.getColorType());
    }

    private String getParamName(ColorParam colorParam, boolean bl) {
        String string = colorParam.name();
        if (bl && string.endsWith("Background")) {
            string = string.replaceAll("Background", "ClickableBackground");
        } else if (bl && string.endsWith("Border")) {
            string = string.replaceAll("Border", "ClickableBorder");
        }
        return string + "color";
    }

    private void checkStereotype(Stereotype stereotype) {
    }

    private int getFontSize(Stereotype stereotype, FontParam ... fontParamArray) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontsize" + stereotype.getLabel(false), fontParamArray);
            if (string != null && string.matches("\\d+")) {
                return Integer.parseInt(string);
            }
        }
        if ((string = this.getFirstValueNonNullWithSuffix("fontsize", fontParamArray)) == null || !string.matches("\\d+")) {
            string = this.getValue("defaultfontsize");
        }
        if (string == null || !string.matches("\\d+")) {
            return fontParamArray[0].getDefaultSize(this);
        }
        return Integer.parseInt(string);
    }

    private String getFontFamily(Stereotype stereotype, FontParam ... fontParamArray) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontname" + stereotype.getLabel(false), fontParamArray);
            if (string != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
            }
        }
        if ((string = this.getFirstValueNonNullWithSuffix("fontname", fontParamArray)) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        if (fontParamArray[0] != FontParam.CIRCLED_CHARACTER && (string = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        return fontParamArray[0].getDefaultFamily();
    }

    @Override
    public HtmlColor getFontHtmlColor(Stereotype stereotype, FontParam ... fontParamArray) {
        String string = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontcolor" + stereotype.getLabel(false), fontParamArray);
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = this.getFirstValueNonNullWithSuffix("fontcolor", fontParamArray);
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = this.getValue("defaultfontcolor");
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = fontParamArray[0].getDefaultColor();
        }
        return this.getIHtmlColorSet().getColorIfValid(string);
    }

    private String getFirstValueNonNullWithSuffix(String string, FontParam ... fontParamArray) {
        for (FontParam fontParam : fontParamArray) {
            String string2 = this.getValue(fontParam.name() + string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private int getFontStyle(Stereotype stereotype, boolean bl, FontParam ... fontParamArray) {
        String string = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontstyle" + stereotype.getLabel(false), fontParamArray);
        }
        if (string == null) {
            string = this.getFirstValueNonNullWithSuffix("fontstyle", fontParamArray);
        }
        if (string == null) {
            string = this.getValue("defaultfontstyle");
        }
        if (string == null) {
            return fontParamArray[0].getDefaultFontStyle(this, bl);
        }
        int n = 0;
        if (StringUtils.goLowerCase(string).contains("bold")) {
            n |= 1;
        }
        if (StringUtils.goLowerCase(string).contains("italic")) {
            n |= 2;
        }
        return n;
    }

    @Override
    public UFont getFont(Stereotype stereotype, boolean bl, FontParam ... fontParamArray) {
        if (stereotype != null) {
            this.checkStereotype(stereotype);
        }
        String string = this.getFontFamily(stereotype, fontParamArray);
        int n = this.getFontStyle(stereotype, bl, fontParamArray);
        int n2 = this.getFontSize(stereotype, fontParamArray);
        return new UFont(string, n, n2);
    }

    @Override
    public int getCircledCharacterRadius() {
        String string = this.getValue("circledcharacterradius");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return this.getFontSize(null, FontParam.CIRCLED_CHARACTER) / 3 + 6;
    }

    @Override
    public int classAttributeIconSize() {
        String string = this.getValue("classAttributeIconSize");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 10;
    }

    public static Collection<String> getPossibleValues() {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("Monochrome");
        treeSet.add("CircledCharacterRadius");
        treeSet.add("ClassAttributeIconSize");
        treeSet.add("DefaultFontName");
        treeSet.add("DefaultFontStyle");
        treeSet.add("DefaultFontSize");
        treeSet.add("DefaultFontColor");
        treeSet.add("MinClassWidth");
        treeSet.add("MinClassWidth");
        treeSet.add("Dpi");
        treeSet.add("DefaultTextAlignment");
        treeSet.add("Shadowing");
        treeSet.add("NoteShadowing");
        treeSet.add("Handwritten");
        treeSet.add("CircledCharacterRadius");
        treeSet.add("ClassAttributeIconSize");
        treeSet.add("Linetype");
        treeSet.add("PackageStyle");
        treeSet.add("ComponentStyle");
        treeSet.add("StereotypePosition");
        treeSet.add("Nodesep");
        treeSet.add("Ranksep");
        treeSet.add("RoundCorner");
        treeSet.add("TitleBorderRoundCorner");
        treeSet.add("MaxMessageSize");
        treeSet.add("Style");
        treeSet.add("SequenceParticipant");
        treeSet.add("ConditionStyle");
        treeSet.add("SameClassWidth");
        treeSet.add("HyperlinkUnderline");
        treeSet.add("Padding");
        treeSet.add("Guillemet");
        treeSet.add("SvglinkTarget");
        treeSet.add("DefaultMonospacedFontName");
        treeSet.add("TabSize");
        treeSet.add("MaxAsciiMessageLength");
        treeSet.add("ColorArrowSeparationSpace");
        for (FontParam enum_ : EnumSet.allOf(FontParam.class)) {
            string = SkinParam.humanName(enum_.name());
            treeSet.add(string + "FontStyle");
            treeSet.add(string + "FontName");
            treeSet.add(string + "FontSize");
            treeSet.add(string + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            string = SkinParam.capitalize(colorParam.name());
            treeSet.add(string + "Color");
        }
        for (LineParam lineParam : EnumSet.allOf(LineParam.class)) {
            string = SkinParam.capitalize(lineParam.name());
            treeSet.add(string + "Thickness");
        }
        return Collections.unmodifiableSet(treeSet);
    }

    private static String capitalize(String string) {
        return StringUtils.goUpperCase(string.substring(0, 1)) + string.substring(1);
    }

    @Override
    public int getDpi() {
        String string = this.getValue("dpi");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 96;
    }

    @Override
    public DotSplines getDotSplines() {
        String string = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(string)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(string)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment(AlignParam alignParam, ArrowDirection arrowDirection) {
        HorizontalAlignment horizontalAlignment;
        String string;
        switch (alignParam) {
            case SEQUENCE_MESSAGE_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 0);
                break;
            }
            case SEQUENCE_MESSAGETEXT_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 1);
                break;
            }
            default: {
                string = this.getValue(alignParam.name());
            }
        }
        if ("direction".equalsIgnoreCase(string)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.LEFT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.RIGHT;
            }
        }
        if ("reversedirection".equalsIgnoreCase(string)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.RIGHT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.LEFT;
            }
        }
        if ((horizontalAlignment = HorizontalAlignment.fromString(string)) == null) {
            return alignParam.getDefaultValue();
        }
        return horizontalAlignment;
    }

    @Override
    public HorizontalAlignment getDefaultTextAlignment(HorizontalAlignment horizontalAlignment) {
        String string = this.getValue("defaulttextalignment");
        HorizontalAlignment horizontalAlignment2 = HorizontalAlignment.fromString(string);
        if (horizontalAlignment2 == null) {
            return horizontalAlignment;
        }
        return horizontalAlignment2;
    }

    private String getArg(String string, int n) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (n >= stringArray.length) {
            return stringArray[0];
        }
        return stringArray[n];
    }

    @Override
    public ColorMapper getColorMapper() {
        String string = this.getValue("monochrome");
        if ("true".equals(string)) {
            return new ColorMapperMonochrome(false);
        }
        if ("reverse".equals(string)) {
            return new ColorMapperMonochrome(true);
        }
        String string2 = this.getValue("reversecolor");
        if (string2 == null) {
            return new ColorMapperIdentity();
        }
        ColorOrder colorOrder = ColorOrder.fromString(string2);
        if (colorOrder == null) {
            return new ColorMapperIdentity();
        }
        return new ColorMapperReverse(colorOrder);
    }

    @Override
    public boolean shadowing() {
        String string = this.getValue("shadowing");
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        if ("true".equalsIgnoreCase(string)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public boolean shadowingForNote(Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue("noteshadowing" + stereotype.getLabel(false));
            if (string != null) {
                return string.equalsIgnoreCase("true");
            }
        }
        if ((string = this.getValue("noteshadowing")) != null) {
            return string.equalsIgnoreCase("true");
        }
        return this.shadowing();
    }

    @Override
    public boolean shadowing2(SkinParameter skinParameter) {
        if (skinParameter == null) {
            throw new IllegalArgumentException();
        }
        String string = skinParameter.getUpperCaseName();
        String string2 = this.getValue(string + "shadowing");
        if (string2 == null) {
            return this.shadowing();
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public PackageStyle getPackageStyle() {
        String string = this.getValue("packageStyle");
        PackageStyle packageStyle = PackageStyle.fromString(string);
        if (packageStyle == null) {
            return PackageStyle.FOLDER;
        }
        return packageStyle;
    }

    public void addSprite(String string, Sprite sprite) {
        this.sprites.put(string, sprite);
    }

    @Override
    public Sprite getSprite(String string) {
        Sprite sprite = this.sprites.get(string);
        if (sprite == null) {
            sprite = SpriteImage.fromInternal(string);
        }
        return sprite;
    }

    @Override
    public boolean useUml2ForComponent() {
        if (this.strictUmlStyle()) {
            return true;
        }
        String string = this.getValue("componentstyle");
        return "uml2".equalsIgnoreCase(string);
    }

    @Override
    public boolean stereotypePositionTop() {
        String string = this.getValue("stereotypePosition");
        return !"bottom".equalsIgnoreCase(string);
    }

    @Override
    public boolean useSwimlanes(UmlDiagramType umlDiagramType) {
        if (umlDiagramType != UmlDiagramType.ACTIVITY) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.getValue("swimlane"))) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getValue("swimlanes"));
    }

    @Override
    public double getNodesep() {
        String string = this.getValue("nodesep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRanksep() {
        String string = this.getValue("ranksep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRoundCorner(String string, Stereotype stereotype) {
        String string2;
        String string3 = string + "roundcorner";
        if (stereotype != null) {
            string3 = string3 + stereotype.getLabel(false);
        }
        if ((string2 = this.getValue(string3)) != null && string2.matches("\\d+")) {
            return Double.parseDouble(string2);
        }
        return 0.0;
    }

    @Override
    public UStroke getThickness(LineParam lineParam, Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue(lineParam.name() + "thickness" + stereotype.getLabel(false));
            if (string != null && string.matches("[\\d.]+")) {
                return new UStroke(Double.parseDouble(string));
            }
        }
        if ((string = this.getValue(lineParam.name() + "thickness")) != null && string.matches("[\\d.]+")) {
            return new UStroke(Double.parseDouble(string));
        }
        return null;
    }

    @Override
    public LineBreakStrategy maxMessageSize() {
        return new LineBreakStrategy(this.getValue("maxmessagesize"));
    }

    @Override
    public boolean strictUmlStyle() {
        String string = this.getValue("style");
        return "strictuml".equalsIgnoreCase(string);
    }

    @Override
    public boolean forceSequenceParticipantUnderlined() {
        String string = this.getValue("sequenceParticipant");
        return "underline".equalsIgnoreCase(string);
    }

    @Override
    public ConditionStyle getConditionStyle() {
        String string = this.getValue("conditionStyle");
        ConditionStyle conditionStyle = ConditionStyle.fromString(string);
        if (conditionStyle == null) {
            return ConditionStyle.INSIDE;
        }
        return conditionStyle;
    }

    @Override
    public double minClassWidth() {
        String string = this.getValue("minclasswidth");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 0.0;
    }

    @Override
    public boolean sameClassWidth() {
        return "true".equals(this.getValue("sameclasswidth"));
    }

    @Override
    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public boolean useOctagonForActivity(Stereotype stereotype) {
        String string = this.getValue("activityshape");
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String string2 = this.getValue("activityshape" + stereotype.getLabel(false));
            if (string2 != null) {
                string = string2;
            }
        }
        if ("roundedbox".equalsIgnoreCase(string)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(string);
    }

    @Override
    public IHtmlColorSet getIHtmlColorSet() {
        return this.htmlColorSet;
    }

    @Override
    public boolean useUnderlineForHyperlink() {
        String string = this.getValue("hyperlinkunderline");
        return !"false".equalsIgnoreCase(string);
    }

    @Override
    public int groupInheritance() {
        String string = this.getValue("groupinheritance");
        int n = Integer.MAX_VALUE;
        if (string != null && string.matches("\\d+")) {
            n = Integer.parseInt(string);
        }
        if (n <= 1) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public boolean useGuillemet() {
        String string = this.getValue("guillemet");
        return !"false".equalsIgnoreCase(string);
    }

    @Override
    public boolean handwritten() {
        String string = this.getValue("handwritten");
        return "true".equalsIgnoreCase(string);
    }

    @Override
    public String getSvgLinkTarget() {
        String string = this.getValue("svglinktarget");
        if (string == null) {
            return "_top";
        }
        return string;
    }

    @Override
    public String getMonospacedFamily() {
        String string = this.getValue("defaultMonospacedFontName");
        if (string == null) {
            return "monospaced";
        }
        return string;
    }

    @Override
    public int getTabSize() {
        String string = this.getValue("tabsize");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 8;
    }

    @Override
    public int maxAsciiMessageLength() {
        String string = this.getValue("maxasciimessagelength");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    @Override
    public int colorArrowSeparationSpace() {
        String string = this.getValue("colorarrowseparationspace");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    @Override
    public SplitParam getSplitParam() {
        String string = this.getValue("pageBorderColor");
        String string2 = this.getValue("pageExternalColor");
        String string3 = this.getValue("pageMargin");
        int n = 0;
        if (string3 != null && string3.matches("\\d+")) {
            n = Integer.parseInt(string3);
        }
        return new SplitParam(this.getIHtmlColorSet().getColorIfValid(string), this.getIHtmlColorSet().getColorIfValid(string2), n);
    }

    @Override
    public int swimlaneWidth() {
        String string = this.getValue("swimlanewidth");
        if ("same".equalsIgnoreCase(string)) {
            return -1;
        }
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return this.type;
    }

    @Override
    public HtmlColor getHoverPathColor() {
        String string = this.getValue("pathhovercolor");
        if (string == null) {
            return null;
        }
        return this.getIHtmlColorSet().getColorIfValid(string, false);
    }

    @Override
    public double getPadding() {
        String string = this.getValue("padding");
        if (string != null && string.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getPadding(PaddingParam paddingParam) {
        String string = this.getValue(paddingParam.getSkinName());
        if (string != null && string.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public boolean useRankSame() {
        return false;
    }
}

