/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.preproc.Defines;

public class Pipe {
    private final Option option;
    private final InputStream is;
    private final PrintStream ps;
    private boolean closed = false;
    private final String charset;

    public Pipe(Option option, PrintStream printStream, InputStream inputStream, String string) {
        this.option = option;
        this.is = inputStream;
        this.ps = printStream;
        this.charset = string;
    }

    public boolean managePipe() throws IOException {
        boolean bl = false;
        boolean bl2 = this.option.isPipeNoStdErr();
        do {
            Object object;
            String string;
            if ((string = this.readOneDiagram()) == null) {
                this.ps.flush();
                return bl;
            }
            SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), string, this.option.getConfig());
            if (this.option.isComputeurl()) {
                for (BlockUml blockUml : sourceStringReader.getBlocks()) {
                    this.ps.println(blockUml.getEncodedUrl());
                }
            } else if (this.option.isSyntax()) {
                object = sourceStringReader.getBlocks().get(0).getDiagram();
                if (object instanceof UmlDiagram) {
                    this.ps.println(((UmlDiagram)object).getUmlDiagramType().name());
                    this.ps.println(object.getDescription());
                } else if (object instanceof PSystemError) {
                    bl = true;
                    this.printErrorText(this.ps, (PSystemError)object);
                } else {
                    this.ps.println("OTHER");
                    this.ps.println(object.getDescription());
                }
            } else if (this.option.isPipeMap()) {
                object = sourceStringReader.getCMapData(0, this.option.getFileFormatOption());
                this.ps.println((String)object);
            } else {
                object = bl2 ? new ByteArrayOutputStream() : this.ps;
                DiagramDescription diagramDescription = sourceStringReader.outputImage((OutputStream)object, this.option.getImageIndex(), this.option.getFileFormatOption());
                if (diagramDescription != null && "(error)".equalsIgnoreCase(diagramDescription.getDescription())) {
                    bl = true;
                    this.manageErrors(bl2 ? this.ps : System.err, sourceStringReader);
                } else if (bl2) {
                    ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object;
                    byteArrayOutputStream.close();
                    this.ps.write(byteArrayOutputStream.toByteArray());
                }
                if (this.option.getPipeDelimitor() != null) {
                    this.ps.println(this.option.getPipeDelimitor());
                }
            }
            this.ps.flush();
        } while (!this.closed);
        return bl;
    }

    private void manageErrors(PrintStream printStream, SourceStringReader sourceStringReader) {
        this.printErrorText(printStream, (PSystemError)sourceStringReader.getBlocks().get(0).getDiagram());
    }

    private void printErrorText(PrintStream printStream, PSystemError pSystemError) {
        printStream.println("ERROR");
        printStream.println(pSystemError.getHigherErrorPosition2().getPosition());
        for (ErrorUml errorUml : pSystemError.getErrorsUml()) {
            printStream.println(errorUml.getError());
        }
        printStream.flush();
    }

    private boolean isFinished(String string) {
        return string == null || string.startsWith("@end");
    }

    private String readOneDiagram() throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((string = this.readOneLine()) == null) {
                this.closed = true;
                continue;
            }
            stringBuilder.append(string);
            stringBuilder.append("\n");
        } while (!this.isFinished(string));
        if (stringBuilder.length() == 0) {
            return null;
        }
        string = stringBuilder.toString();
        if (!string.startsWith("@start")) {
            string = "@startuml\n" + string + "\n@enduml";
        }
        return string;
    }

    private String readOneLine() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if ((n = this.is.read()) == -1) {
                if (byteArrayOutputStream.size() == 0) {
                    return null;
                }
                break;
            }
            if (n == 13 || n == 10) continue;
            byteArrayOutputStream.write(n);
        } while (n != 10);
        if (this.charset == null) {
            return new String(byteArrayOutputStream.toByteArray());
        }
        return new String(byteArrayOutputStream.toByteArray(), this.charset);
    }
}

