/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.Preprocessor;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final UncommentReadLine reader2;
    private final Defines defines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> list, String string, Defines defines, Reader reader, File file, String string2) throws IOException {
        Preprocessor preprocessor = null;
        this.defines = defines;
        try {
            this.reader2 = new UncommentReadLine(new ReadLineReader(reader, string2));
            preprocessor = new Preprocessor(this.reader2, string, defines, file, this);
            this.init(preprocessor, list);
        }
        finally {
            if (preprocessor != null) {
                preprocessor.close();
                this.usedFiles = preprocessor.getFilesUsed();
            }
        }
    }

    public BlockUmlBuilder(List<String> list, String string, Defines defines, Reader reader) throws IOException {
        this(list, string, defines, reader, null, null);
    }

    private void init(Preprocessor preprocessor, List<String> list) throws IOException {
        CharSequence2 charSequence2 = null;
        ArrayList<CharSequence2> arrayList = null;
        boolean bl = false;
        int n = 0;
        while ((charSequence2 = preprocessor.readLine()) != null) {
            CharSequence2 charSequence22;
            if (StartUtils.isArobaseStartDiagram(charSequence2)) {
                arrayList = new ArrayList<CharSequence2>();
                bl = false;
                n = preprocessor.getLineNumber();
            }
            if (StartUtils.isArobasePauseDiagram(charSequence2)) {
                bl = true;
                this.reader2.setPaused(true);
            }
            if (arrayList != null && !bl) {
                arrayList.add(charSequence2);
            } else if (bl && (charSequence22 = StartUtils.getPossibleAppend(charSequence2)) != null) {
                arrayList.add(charSequence22);
            }
            if (StartUtils.isArobaseUnpauseDiagram(charSequence2)) {
                bl = false;
                this.reader2.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(charSequence2) || arrayList == null) continue;
            arrayList.addAll(1, this.convert(list, new LineLocationImpl(null, null).oneLineRead()));
            this.blocks.add(new BlockUml(arrayList, n - list.size(), this.defines.cloneMe()));
            arrayList = null;
            this.reader2.setPaused(false);
        }
    }

    private Collection<CharSequence2> convert(List<String> list, LineLocation lineLocation) {
        ArrayList<CharSequence2> arrayList = new ArrayList<CharSequence2>();
        for (String string : list) {
            arrayList.add(new CharSequence2Impl(string, lineLocation));
        }
        return arrayList;
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<? extends CharSequence> getDefinition(String string) {
        for (BlockUml blockUml : this.blocks) {
            if (!blockUml.isStartDef(string)) continue;
            this.defines.importFrom(blockUml.getLocalDefines());
            return blockUml.getDefinition();
        }
        return Collections.emptyList();
    }
}

