/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockUml {
    private final List<CharSequence2> data;
    private final int startLine;
    private Diagram system;
    private final Defines localDefines;

    BlockUml(String ... stringArray) {
        this(BlockUml.convert(stringArray), 0, Defines.createEmpty());
    }

    public String getEncodedUrl() throws IOException {
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        String string = this.getDiagram().getSource().getPlainString();
        String string2 = transcoder.encode(string);
        return string2;
    }

    public String getFlashData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence2 charSequence2 : this.data) {
            stringBuilder.append(charSequence2);
            stringBuilder.append('\r');
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence2> convert(String ... stringArray) {
        return BlockUml.convert(Arrays.asList(stringArray));
    }

    public static List<CharSequence2> convert(List<String> list) {
        ArrayList<CharSequence2> arrayList = new ArrayList<CharSequence2>();
        LineLocationImpl lineLocationImpl = new LineLocationImpl("block", null);
        for (String string : list) {
            lineLocationImpl = lineLocationImpl.oneLineRead();
            arrayList.add(new CharSequence2Impl(string, lineLocationImpl));
        }
        return arrayList;
    }

    public BlockUml(List<CharSequence2> list, int n, Defines defines) {
        this.startLine = n;
        this.localDefines = defines;
        CharSequence2 charSequence2 = list.get(0).trin();
        if (!StartUtils.startsWithSymbolAnd("start", charSequence2)) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence2>(list);
    }

    public String getFileOrDirname() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher2 matcher2 = StartUtils.patternFilename.matcher(StringUtils.trin(this.data.get(0).toString()));
        boolean bl = matcher2.find();
        if (!bl) {
            return null;
        }
        String string = matcher2.group(1);
        int n = string.indexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        }
        string = string.replaceAll("\\.\\w\\w\\w$", "");
        return string;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = new PSystemBuilder().createPSystem(this.data, this.startLine);
        }
        return this.system;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final List<CharSequence2> getData() {
        return this.data;
    }

    private String internalEtag() {
        try {
            AsciiEncoder asciiEncoder = new AsciiEncoder();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (CharSequence charSequence : this.data) {
                messageDigest.update(charSequence.toString().getBytes("UTF-8"));
            }
            Object object = messageDigest.digest();
            return asciiEncoder.encode((byte[])object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "NOETAG";
        }
    }

    public String etag() {
        return Version.etag() + this.internalEtag();
    }

    public long lastModified() {
        return Version.compileTime() / 1000L / 60L * 1000L * 60L + (long)Version.beta() * 1000L * 3600L;
    }

    public boolean isStartDef(String string) {
        String string2 = "@startdef(id=" + string + ")";
        return this.data.get(0).toString().equalsIgnoreCase(string2);
    }

    public List<? extends CharSequence> getDefinition() {
        if (!this.data.get(0).toString().startsWith("@startdef")) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableList(this.data.subList(1, this.data.size() - 1));
    }

    public Defines getLocalDefines() {
        return this.localDefines;
    }
}

