/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.xmi.IXmiClassDiagram;
import net.sourceforge.plantuml.xmi.XmiClassDiagramArgo;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStandard;
import net.sourceforge.plantuml.xmi.XmiClassDiagramStar;
import net.sourceforge.plantuml.xmi.XmiDescriptionDiagram;
import net.sourceforge.plantuml.xmi.XmiStateDiagram;

public final class CucaDiagramXmiMaker {
    private final CucaDiagram diagram;
    private final FileFormat fileFormat;

    public CucaDiagramXmiMaker(CucaDiagram cucaDiagram, FileFormat fileFormat) throws IOException {
        this.diagram = cucaDiagram;
        this.fileFormat = fileFormat;
    }

    public static String getModel(UmlDiagram umlDiagram) {
        return "model1";
    }

    public void createFiles(OutputStream outputStream) throws IOException {
        try {
            IXmiClassDiagram iXmiClassDiagram;
            if (this.diagram instanceof StateDiagram) {
                iXmiClassDiagram = new XmiStateDiagram((StateDiagram)this.diagram);
            } else if (this.diagram instanceof DescriptionDiagram) {
                iXmiClassDiagram = new XmiDescriptionDiagram((DescriptionDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STANDARD) {
                iXmiClassDiagram = new XmiClassDiagramStandard((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_ARGO) {
                iXmiClassDiagram = new XmiClassDiagramArgo((ClassDiagram)this.diagram);
            } else if (this.fileFormat == FileFormat.XMI_STAR) {
                iXmiClassDiagram = new XmiClassDiagramStar((ClassDiagram)this.diagram);
            } else {
                throw new UnsupportedOperationException();
            }
            iXmiClassDiagram.transformerXml(outputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.error(parserConfigurationException.toString());
            parserConfigurationException.printStackTrace();
            throw new IOException(parserConfigurationException.toString());
        }
        catch (TransformerException transformerException) {
            Log.error(transformerException.toString());
            transformerException.printStackTrace();
            throw new IOException(transformerException.toString());
        }
    }
}

