/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.BoolDecoder;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.LoopFilter;
import net.sourceforge.plantuml.webp.MacroBlock;
import net.sourceforge.plantuml.webp.SegmentQuants;
import net.sourceforge.plantuml.webp.SubBlock;

public class VP8Frame {
    private static int BLOCK_TYPES = 4;
    private static int COEF_BANDS = 8;
    private static int MAX_ENTROPY_TOKENS = 12;
    private static int MAX_MODE_LF_DELTAS = 4;
    private static int MAX_REF_LF_DELTAS = 4;
    private static int PREV_COEF_CONTEXTS = 3;
    private ArrayList<IIOReadProgressListener> _listeners = new ArrayList();
    private int bufferCount;
    private int buffersToCreate = 1;
    private int[][][][] coefProbs;
    private boolean debug = false;
    private int filterLevel;
    private int filterType;
    private ImageInputStream frame;
    private int frameType;
    private int height;
    private int macroBlockCols;
    private int macroBlockNoCoeffSkip;
    private int macroBlockRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private int[] modeLoopFilterDeltas = new int[MAX_MODE_LF_DELTAS];
    private int modeRefLoopFilterDeltaEnabled;
    private int modeRefLoopFilterDeltaUpdate;
    private int multiTokenPartition = 0;
    private long offset;
    private int[] refLoopFilterDeltas = new int[MAX_REF_LF_DELTAS];
    private int refreshEntropyProbs;
    private int refreshLastFrame;
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private int simpleFilter;
    private BoolDecoder tokenBoolDecoder;
    private Vector<BoolDecoder> tokenBoolDecoders;
    private int updateMacroBlockSegmentationMap;
    private int updateMacroBlockSegmentatonData;
    private int width;

    public VP8Frame(ImageInputStream imageInputStream) throws IOException {
        this.frame = imageInputStream;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.tokenBoolDecoders = new Vector();
    }

    public VP8Frame(ImageInputStream imageInputStream, int[][][][] nArray) throws IOException {
        this.frame = imageInputStream;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = nArray;
        this.tokenBoolDecoders = new Vector();
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this._listeners.add(iIOReadProgressListener);
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.macroBlockCols + 2][this.macroBlockRows + 2];
        for (int i = 0; i < this.macroBlockCols + 2; ++i) {
            for (int j = 0; j < this.macroBlockRows + 2; ++j) {
                this.macroBlocks[i][j] = new MacroBlock(i, j, this.debug);
            }
        }
    }

    public boolean decodeFrame(boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        this.debug = bl;
        this.segmentQuants = new SegmentQuants();
        this.frame.seek(this.offset++);
        int n4 = this.frame.readUnsignedByte();
        this.frameType = this.getBitAsInt(n4, 0);
        if (this.frameType != 0) {
            return false;
        }
        int n5 = this.getBitAsInt(n4, 1) << 1;
        n5 += this.getBitAsInt(n4, 2) << 1;
        n5 += this.getBitAsInt(n4, 3);
        int n6 = this.getBitAsInt(n4, 5) << 0;
        n6 += this.getBitAsInt(n4, 6) << 1;
        n6 += this.getBitAsInt(n4, 7) << 2;
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        n6 += n4 << 3;
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        n6 += n4 << 11;
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        int n7 = n4 = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        this.width = (n7 += n4 << 8) & 0x3FFF;
        this.frame.seek(this.offset++);
        int n8 = n4 = this.frame.readUnsignedByte();
        this.frame.seek(this.offset++);
        n4 = this.frame.readUnsignedByte();
        this.height = (n8 += n4 << 8) & 0x3FFF;
        int n9 = this.width;
        int n10 = this.height;
        if ((n9 & 0xF) != 0) {
            n9 += 16 - (n9 & 0xF);
        }
        if ((n10 & 0xF) != 0) {
            n10 += 16 - (n10 & 0xF);
        }
        this.macroBlockRows = n10 >> 4;
        this.macroBlockCols = n9 >> 4;
        this.createMacroBlocks();
        BoolDecoder boolDecoder = new BoolDecoder(this.frame, this.offset);
        if (this.frameType == 0) {
            n3 = boolDecoder.readBit();
            n2 = boolDecoder.readBit();
        }
        this.segmentationIsEnabled = boolDecoder.readBit();
        if (this.segmentationIsEnabled > 0) {
            this.updateMacroBlockSegmentationMap = boolDecoder.readBit();
            this.updateMacroBlockSegmentatonData = boolDecoder.readBit();
            if (this.updateMacroBlockSegmentatonData > 0) {
                this.macroBlockSegementAbsoluteDelta = boolDecoder.readBit();
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n2 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[0]);
                        if (boolDecoder.readBit() > 0) {
                            n2 = -n2;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n3].setQindex(n2);
                }
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n2 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[1]);
                        if (boolDecoder.readBit() > 0) {
                            n2 = -n2;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n3].setFilterStrength(n2);
                }
                if (this.updateMacroBlockSegmentationMap > 0) {
                    this.macroBlockSegmentTreeProbs = new int[3];
                    for (n3 = 0; n3 < 3; ++n3) {
                        n2 = 255;
                        n2 = boolDecoder.readBit() > 0 ? boolDecoder.readLiteral(8) : 255;
                        this.macroBlockSegmentTreeProbs[n3] = n2;
                    }
                }
            }
        }
        this.simpleFilter = boolDecoder.readBit();
        this.filterLevel = boolDecoder.readLiteral(6);
        this.sharpnessLevel = boolDecoder.readLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = boolDecoder.readBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0) {
            this.modeRefLoopFilterDeltaUpdate = boolDecoder.readBit();
            if (this.modeRefLoopFilterDeltaUpdate > 0) {
                for (n3 = 0; n3 < MAX_REF_LF_DELTAS; ++n3) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n3] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n3] = this.refLoopFilterDeltas[n3] * -1;
                }
                for (n3 = 0; n3 < MAX_MODE_LF_DELTAS; ++n3) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n3] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n3] = this.modeLoopFilterDeltas[n3] * -1;
                }
            }
        }
        this.filterType = this.filterLevel == 0 ? 0 : (this.simpleFilter > 0 ? 1 : 2);
        this.setupTokenDecoder(boolDecoder, n6, this.offset);
        boolDecoder.seek();
        this.segmentQuants.parse(boolDecoder, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.refreshEntropyProbs = boolDecoder.readBit();
        if (this.refreshEntropyProbs > 0) {
            // empty if block
        }
        this.refreshLastFrame = 0;
        this.refreshLastFrame = this.frameType == 0 ? 1 : boolDecoder.readBit();
        for (n3 = 0; n3 < BLOCK_TYPES; ++n3) {
            for (n2 = 0; n2 < COEF_BANDS; ++n2) {
                for (n = 0; n < PREV_COEF_CONTEXTS; ++n) {
                    for (int i = 0; i < MAX_ENTROPY_TOKENS - 1; ++i) {
                        int n11;
                        if (boolDecoder.readBool(Globals.vp8CoefUpdateProbs[n3][n2][n][i]) <= 0) continue;
                        this.coefProbs[n3][n2][n][i] = n11 = boolDecoder.readLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = boolDecoder.readBit();
        if (this.frameType != 0) {
            throw new IllegalArgumentException("bad input: not intra");
        }
        this.readModes(boolDecoder);
        n3 = 0;
        n2 = 1 << this.multiTokenPartition;
        for (n = 0; n < this.macroBlockRows; ++n) {
            if (n2 > 1) {
                this.tokenBoolDecoder = this.tokenBoolDecoders.elementAt(n3);
                this.tokenBoolDecoder.seek();
                this.decodeMacroBlockRow(n);
                if (++n3 == n2) {
                    n3 = 0;
                }
            } else {
                this.decodeMacroBlockRow(n);
            }
            this.fireProgressUpdate(n);
        }
        if (this.getFilterType() > 0 && this.getFilterLevel() != 0) {
            this.loopFilter();
        }
        return true;
    }

    private void decodeMacroBlockRow(int n) throws IOException {
        for (int i = 0; i < this.macroBlockCols; ++i) {
            MacroBlock macroBlock = this.getMacroBlock(i, n);
            macroBlock.decodeMacroBlock(this);
            macroBlock.dequantMacroBlock(this);
        }
    }

    public void fireLFProgressUpdate(float f) {
        Iterator<IIOReadProgressListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().imageProgress(null, (float)(100 / this.buffersToCreate) + f / (float)this.buffersToCreate);
        }
    }

    private void fireProgressUpdate(int n) {
        Iterator<IIOReadProgressListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().imageProgress(null, 100.0f * ((float)(n + 1) / (float)this.getMacroBlockRows()) / (float)this.buffersToCreate);
        }
    }

    public void fireRGBProgressUpdate(float f) {
        Iterator<IIOReadProgressListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().imageProgress(null, (float)((this.bufferCount + 4) * (100 / this.buffersToCreate)) + f / (float)this.buffersToCreate);
        }
    }

    public SubBlock getAboveRightSubBlock(SubBlock subBlock, SubBlock.PLANE pLANE) {
        MacroBlock macroBlock = subBlock.getMacroBlock();
        int n = macroBlock.getSubblockX(subBlock);
        int n2 = macroBlock.getSubblockY(subBlock);
        if (pLANE == SubBlock.PLANE.Y1) {
            if (n2 == 0 && n < 3) {
                MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
                SubBlock subBlock2 = macroBlock2.getSubBlock(pLANE, n + 1, 3);
                return subBlock2;
            }
            if (n2 == 0 && n == 3) {
                MacroBlock macroBlock3 = this.getMacroBlock(macroBlock.getX() + 1, macroBlock.getY() - 1);
                SubBlock subBlock3 = macroBlock3.getSubBlock(pLANE, 0, 3);
                if (macroBlock3.getX() == this.getMacroBlockCols()) {
                    int[][] nArray = new int[4][4];
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            nArray[j][i] = macroBlock3.getY() < 0 ? 127 : this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1).getSubBlock(SubBlock.PLANE.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    subBlock3 = new SubBlock(macroBlock3, null, null, SubBlock.PLANE.Y1);
                    subBlock3.setDest(nArray);
                }
                return subBlock3;
            }
            if (n2 > 0 && n < 3) {
                SubBlock subBlock4 = macroBlock.getSubBlock(pLANE, n + 1, n2 - 1);
                return subBlock4;
            }
            SubBlock subBlock5 = macroBlock.getSubBlock(subBlock.getPlane(), 3, 0);
            return this.getAboveRightSubBlock(subBlock5, pLANE);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getAboveSubBlock(SubBlock subBlock, SubBlock.PLANE pLANE) {
        SubBlock subBlock2 = subBlock.getAbove();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n = macroBlock.getSubblockX(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
            while (pLANE == SubBlock.PLANE.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX(), macroBlock2.getY() - 1);
            }
            subBlock2 = macroBlock2.getBottomSubBlock(n, subBlock.getPlane());
        }
        return subBlock2;
    }

    private boolean getBit(int n, int n2) {
        int n3 = n & 1 << n2;
        return n3 > 0;
    }

    private int getBitAsInt(int n, int n2) {
        int n3 = n & 1 << n2;
        if (n3 > 0) {
            return 1;
        }
        return 0;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.useBufferedImage(bufferedImage);
        ++this.bufferCount;
        return bufferedImage;
    }

    public int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public BufferedImage getDebugImageDiff() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int[] nArray = new int[3];
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getDiff()[i % 4][j % 4];
                int n2 = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int n3 = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n - 16) + 1.596 * (double)(n3 - 128));
                nArray[1] = (int)(1.164 * (double)(n - 16) - 0.813 * (double)(n3 - 128) - 0.391 * (double)(n2 - 128));
                nArray[2] = (int)(1.164 * (double)(n - 16) + 2.018 * (double)(n2 - 128));
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImagePredict() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int[] nArray = new int[3];
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getPredict()[i % 4][j % 4];
                int n2 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int n3 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n - 16) + 1.596 * (double)(n3 - 128));
                nArray[1] = (int)(1.164 * (double)(n - 16) - 0.813 * (double)(n3 - 128) - 0.391 * (double)(n2 - 128));
                nArray[2] = (int)(1.164 * (double)(n - 16) + 2.018 * (double)(n2 - 128));
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageUBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageUDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageUPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageVBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageVDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDiff()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageVPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getPredict()[i / 2 % 4][j / 2 % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageYBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getDest()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageYDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = 127 + this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getDiff()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public BufferedImage getDebugImageYPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getPredict()[i % 4][j % 4];
                int[] nArray = new int[]{n, n, n};
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
        ++this.bufferCount;
        return bufferedImage;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public int getHeight() {
        return this.height;
    }

    public SubBlock getLeftSubBlock(SubBlock subBlock, SubBlock.PLANE pLANE) {
        SubBlock subBlock2 = subBlock.getLeft();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n = macroBlock.getSubblockY(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX() - 1, macroBlock.getY());
            while (pLANE == SubBlock.PLANE.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX() - 1, macroBlock2.getY());
            }
            subBlock2 = macroBlock2.getRightSubBlock(n, subBlock.getPlane());
        }
        return subBlock2;
    }

    public MacroBlock getMacroBlock(int n, int n2) {
        return this.macroBlocks[n + 1][n2 + 1];
    }

    public int getMacroBlockCols() {
        return this.macroBlockCols;
    }

    public String getMacroBlockDebugString(int n, int n2, int n3, int n4) {
        String string = new String();
        if (n < this.macroBlockCols && n2 < this.getMacroBlockRows()) {
            MacroBlock macroBlock = this.getMacroBlock(n, n2);
            string = string + macroBlock.getDebugString();
            if (n3 < 4 && n4 < 4) {
                SubBlock subBlock = macroBlock.getSubBlock(SubBlock.PLANE.Y1, n3, n4);
                string = string + "\n SubBlock " + n3 + ", " + n4 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.PLANE.Y2, n3, n4);
                string = string + "\n SubBlock " + n3 + ", " + n4 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.PLANE.U, n3 / 2, n4 / 2);
                string = string + "\n SubBlock " + n3 / 2 + ", " + n4 / 2 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.PLANE.V, n3 / 2, n4 / 2);
                string = string + "\n SubBlock " + n3 / 2 + ", " + n4 / 2 + "\n  " + subBlock.getDebugString();
            }
        }
        return string;
    }

    public int getMacroBlockRows() {
        return this.macroBlockRows;
    }

    public int getQIndex() {
        return this.segmentQuants.getqIndex();
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public BoolDecoder getTokenBoolDecoder() throws IOException {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    public int[][] getUBuffer() {
        int[][] nArray = new int[this.macroBlockCols * 8][this.macroBlockRows * 8];
        for (int i = 0; i < this.macroBlockRows; ++i) {
            for (int j = 0; j < this.macroBlockCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        SubBlock subBlock = macroBlock.getUSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[j * 8 + i2 * 4 + i4][i * 8 + k * 4 + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public int[][] getVBuffer() {
        int[][] nArray = new int[this.macroBlockCols * 8][this.macroBlockRows * 8];
        for (int i = 0; i < this.macroBlockRows; ++i) {
            for (int j = 0; j < this.macroBlockCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        SubBlock subBlock = macroBlock.getVSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[j * 8 + i2 * 4 + i4][i * 8 + k * 4 + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public int getWidth() {
        return this.width;
    }

    public int[][] getYBuffer() {
        int[][] nArray = new int[this.macroBlockCols * 16][this.macroBlockRows * 16];
        for (int i = 0; i < this.macroBlockRows; ++i) {
            for (int j = 0; j < this.macroBlockCols; ++j) {
                MacroBlock macroBlock = this.macroBlocks[j + 1][i + 1];
                for (int k = 0; k < 4; ++k) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        SubBlock subBlock = macroBlock.getYSubBlock(i2, k);
                        for (int i3 = 0; i3 < 4; ++i3) {
                            for (int i4 = 0; i4 < 4; ++i4) {
                                nArray[j * 16 + i2 * 4 + i4][i * 16 + k * 4 + i3] = subBlock.getDest()[i4][i3];
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    public void loopFilter() {
        LoopFilter.loopFilter(this);
    }

    private void readModes(BoolDecoder boolDecoder) throws IOException {
        int n = -1;
        int n2 = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            n2 = boolDecoder.readLiteral(8);
        }
        while (++n < this.macroBlockRows) {
            int n3 = -1;
            while (++n3 < this.macroBlockCols) {
                SubBlock subBlock;
                int n4;
                int n5;
                int n6;
                MacroBlock macroBlock = this.getMacroBlock(n3, n);
                if (this.segmentationIsEnabled > 0 && this.updateMacroBlockSegmentationMap > 0) {
                    n6 = boolDecoder.readTree(Globals.macroBlockSegmentTree, this.macroBlockSegmentTreeProbs);
                    macroBlock.setSegmentId(n6);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    n6 = this.filterLevel;
                    n6 = (n6 += this.refLoopFilterDeltas[0]) < 0 ? 0 : (n6 > 63 ? 63 : n6);
                    macroBlock.setFilterLevel(n6);
                } else {
                    macroBlock.setFilterLevel(this.segmentQuants.getSegQuants()[macroBlock.getSegmentId()].getFilterStrength());
                }
                n6 = 0;
                n6 = this.macroBlockNoCoeffSkip > 0 ? boolDecoder.readBool(n2) : 0;
                macroBlock.setSkipCoeff(n6);
                int n7 = this.readYMode(boolDecoder);
                macroBlock.setYMode(n7);
                if (n7 == 4) {
                    for (n5 = 0; n5 < 4; ++n5) {
                        for (n4 = 0; n4 < 4; ++n4) {
                            SubBlock subBlock2 = macroBlock.getYSubBlock(n4, n5);
                            subBlock = this.getAboveSubBlock(subBlock2, SubBlock.PLANE.Y1);
                            SubBlock subBlock3 = this.getLeftSubBlock(subBlock2, SubBlock.PLANE.Y1);
                            int n8 = this.readSubBlockMode(boolDecoder, subBlock.getMode(), subBlock3.getMode());
                            subBlock2.setMode(n8);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        n5 = macroBlock.getFilterLevel();
                        n5 = (n5 += this.modeLoopFilterDeltas[0]) < 0 ? 0 : (n5 > 63 ? 63 : n5);
                        macroBlock.setFilterLevel(n5);
                    }
                } else {
                    switch (n7) {
                        case 0: {
                            n5 = 0;
                            break;
                        }
                        case 1: {
                            n5 = 2;
                            break;
                        }
                        case 2: {
                            n5 = 3;
                            break;
                        }
                        case 3: {
                            n5 = 1;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    for (n4 = 0; n4 < 4; ++n4) {
                        for (int i = 0; i < 4; ++i) {
                            subBlock = macroBlock.getYSubBlock(n4, i);
                            subBlock.setMode(n5);
                        }
                    }
                }
                n5 = this.readUvMode(boolDecoder);
                macroBlock.setUvMode(n5);
            }
        }
    }

    private int readPartitionSize(long l) throws IOException {
        this.frame.seek(l);
        int n = this.frame.readUnsignedByte() + (this.frame.readUnsignedByte() << 8) + (this.frame.readUnsignedByte() << 16);
        return n;
    }

    private int readSubBlockMode(BoolDecoder boolDecoder, int n, int n2) throws IOException {
        int n3 = boolDecoder.readTree(Globals.vp8SubBlockModeTree, Globals.vp8KeyFrameSubBlockModeProb[n][n2]);
        return n3;
    }

    private int readUvMode(BoolDecoder boolDecoder) throws IOException {
        int n = boolDecoder.readTree(Globals.vp8UVModeTree, Globals.vp8KeyFrameUVModeProb);
        return n;
    }

    private int readYMode(BoolDecoder boolDecoder) throws IOException {
        int n = boolDecoder.readTree(Globals.vp8KeyFrameYModeTree, Globals.vp8KeyFrameYModeProb);
        return n;
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this._listeners.remove(iIOReadProgressListener);
    }

    public void setBuffersToCreate(int n) {
        this.buffersToCreate = 3 + n;
        this.bufferCount = 0;
    }

    private void setupTokenDecoder(BoolDecoder boolDecoder, int n, long l) throws IOException {
        long l2;
        long l3 = 0L;
        long l4 = l2 = l + (long)n;
        this.multiTokenPartition = boolDecoder.readLiteral(2);
        int n2 = 1 << this.multiTokenPartition;
        if (n2 > 1) {
            l4 += (long)(3 * (n2 - 1));
        }
        for (int i = 0; i < n2; ++i) {
            if (i < n2 - 1) {
                l3 = this.readPartitionSize(l2 + (long)(i * 3));
                boolDecoder.seek();
            } else {
                l3 = this.frame.length() - l4;
            }
            this.tokenBoolDecoders.add(new BoolDecoder(this.frame, l4));
            l4 += l3;
        }
        this.tokenBoolDecoder = this.tokenBoolDecoders.elementAt(0);
    }

    public void useBufferedImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                int[] nArray = new int[3];
                int n = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.Y1, i % 16 / 4, j % 16 / 4).getDest()[i % 4][j % 4];
                int n2 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.U, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                int n3 = this.getMacroBlock(i / 16, j / 16).getSubBlock(SubBlock.PLANE.V, i / 2 % 8 / 4, j / 2 % 8 / 4).getDest()[i / 2 % 4][j / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n - 16) + 1.596 * (double)(n3 - 128));
                nArray[1] = (int)(1.164 * (double)(n - 16) - 0.813 * (double)(n3 - 128) - 0.391 * (double)(n2 - 128));
                nArray[2] = (int)(1.164 * (double)(n - 16) + 2.018 * (double)(n2 - 128));
                for (int k = 0; k < 3; ++k) {
                    if (nArray[k] < 0) {
                        nArray[k] = 0;
                    }
                    if (nArray[k] <= 255) continue;
                    nArray[k] = 255;
                }
                writableRaster.setPixel(i, j, nArray);
            }
            this.fireRGBProgressUpdate(100.0f * (float)i / (float)this.getWidth());
        }
    }

    public void setFrame(ImageInputStream imageInputStream) {
        try {
            this.frame.flush();
            this.frame.close();
            this.frame = imageInputStream;
            this.offset = imageInputStream.getStreamPosition();
            this.coefProbs = Globals.getDefaultCoefProbs();
            this.tokenBoolDecoders = new Vector();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

