/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.webp.Portrait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Portraits {
    private static final List<Portrait> all = new ArrayList<Portrait>();
    private static final AtomicInteger current = new AtomicInteger();

    private static InputStream getInputStream() {
        return PSystemVersion.class.getResourceAsStream("out.png");
    }

    private static void read(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(dataInputStream.readUTF());
            arrayList2.add(Integer.valueOf(dataInputStream.readByte()));
            arrayList3.add(dataInputStream.readUTF());
        }
        for (n = 0; n < n2; ++n) {
            short s = dataInputStream.readShort();
            byte[] byArray = new byte[s];
            dataInputStream.readFully(byArray);
            all.add(new Portrait((String)arrayList.get(n), (Integer)arrayList2.get(n), (String)arrayList3.get(n), byArray));
        }
        Collections.shuffle(all);
    }

    public static Portrait getOne() {
        if (all.size() == 0) {
            return null;
        }
        int n = current.get() % all.size();
        return all.get(n);
    }

    public static void nextOne() {
        current.getAndIncrement();
    }

    public static Portrait getOne(String string) {
        Portrait portrait = null;
        for (Portrait portrait2 : all) {
            int n = Portraits.similar(portrait2.getName(), string);
            if (n > 3 || portrait != null && n < Portraits.similar(portrait.getName(), string)) continue;
            portrait = portrait2;
        }
        return portrait;
    }

    public static int similar(String string, String string2) {
        int[] nArray = Portraits.countLetter(string);
        int[] nArray2 = Portraits.countLetter(string2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += Math.abs(nArray[i] - nArray2[i]);
        }
        return n;
    }

    private static String noAccent(String string) {
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    private static int[] countLetter(String string) {
        string = Portraits.noAccent(string).toLowerCase(Locale.US);
        int[] nArray = new int[26];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < 'a' || c > 'z') continue;
            int n = c - 97;
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    static final List<Portrait> getAll() {
        return all;
    }

    static {
        InputStream inputStream = Portraits.getInputStream();
        if (inputStream != null) {
            try {
                Portraits.read(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

