/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        HtmlColor htmlColor;
        UPolygon uPolygon = (UPolygon)uShape;
        double[] dArray = new double[uPolygon.getPoints().size() * 2];
        int n = 0;
        for (Point2D point2D : uPolygon.getPoints()) {
            dArray[n++] = point2D.getX() + d;
            dArray[n++] = point2D.getY() + d2;
        }
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            void htmlColor2;
            boolean i = false;
            while (htmlColor2 < dArray.length) {
                if (!uClip.isInside(dArray[htmlColor2], dArray[htmlColor2 + true])) {
                    return;
                }
                htmlColor2 += 2;
            }
        }
        if (uPolygon.getDeltaShadow() != 0.0) {
            epsGraphics.epsPolygonShadow(uPolygon.getDeltaShadow(), dArray);
        }
        if ((htmlColor = uParam.getBackcolor()) instanceof HtmlColorGradient) {
            epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
            epsGraphics.epsPolygon((HtmlColorGradient)htmlColor, colorMapper, dArray);
        } else {
            epsGraphics.setFillColor(colorMapper.getMappedColor(htmlColor));
            epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
            epsGraphics.epsPolygon(dArray);
        }
    }
}

