/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.crossing;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.CrossingSegment;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicCrossing
implements UGraphic {
    private final UGraphic ug;
    private final List<Pending> lines;
    private final UTranslate translate;

    public UGraphicCrossing(UGraphic uGraphic) {
        this(uGraphic, new UTranslate(), new ArrayList<Pending>());
    }

    private static boolean isClose(Point2D point2D, Point2D point2D2) {
        return point2D.distance(point2D2) < 0.1;
    }

    private UGraphicCrossing(UGraphic uGraphic, UTranslate uTranslate, List<Pending> list) {
        this.ug = uGraphic;
        this.translate = uTranslate;
        this.lines = list;
    }

    @Override
    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    @Override
    public UParam getParam() {
        return this.ug.getParam();
    }

    @Override
    public void draw(UShape uShape) {
        if (uShape instanceof DotPath) {
            this.drawDotPath((DotPath)uShape);
        } else {
            this.ug.draw(uShape);
        }
    }

    private void drawDotPath(DotPath dotPath) {
        if (dotPath.isLine()) {
            for (LineSegmentDouble lineSegmentDouble : dotPath.getLineSegments()) {
                this.lines.add(new Pending(this.ug.apply(this.translate.reverse()), this.translate, lineSegmentDouble.translate(this.translate)));
            }
        } else {
            this.ug.draw(dotPath);
        }
    }

    @Override
    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new UGraphicCrossing(this.ug.apply(uChange), this.translate.compose((UTranslate)uChange), this.lines);
        }
        return new UGraphicCrossing(this.ug.apply(uChange), this.translate, this.lines);
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    @Override
    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    @Override
    public void closeAction() {
        this.ug.closeAction();
    }

    @Override
    public void flushUg() {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<Balloon> arrayList2 = new ArrayList<Balloon>();
        for (Pending object2 : this.lines) {
            List<Point2D> list = object2.getCollisionsWith(this.lines);
            Iterator<Point2D> iterator = list.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                arrayList2.add(new Balloon((Point2D)object, 5.0));
            }
        }
        for (Balloon balloon : arrayList2) {
            balloon.drawU(this.ug.apply(new UChangeBackColor(HtmlColorUtils.GREEN)).apply(new UChangeColor(HtmlColorUtils.GREEN)));
        }
        for (Pending pending : this.lines) {
            for (Balloon balloon : arrayList2) {
                object = new CrossingSegment(balloon, pending.segment).intersection();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Point2D point2D = (Point2D)iterator.next();
                    Balloon balloon2 = new Balloon(point2D, 2.0);
                    balloon2.drawU(this.ug.apply(new UChangeBackColor(HtmlColorUtils.BLUE)).apply(new UChangeColor(HtmlColorUtils.BLUE)));
                }
            }
        }
        this.ug.flushUg();
    }

    @Override
    public boolean matchesProperty(String string) {
        return this.ug.matchesProperty(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pending {
        final UGraphic ug;
        final LineSegmentDouble segment;
        final UTranslate translate;

        Pending(UGraphic uGraphic, UTranslate uTranslate, LineSegmentDouble lineSegmentDouble) {
            this.ug = uGraphic;
            this.segment = lineSegmentDouble;
            this.translate = uTranslate;
        }

        void drawNow(HtmlColor htmlColor) {
            if (htmlColor == null) {
                this.segment.draw(this.ug);
            } else {
                this.segment.draw(this.ug.apply(new UChangeColor(htmlColor)));
            }
        }

        List<Point2D> getCollisionsWith(List<Pending> list) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            for (Pending pending : list) {
                Point2D point2D;
                if (UGraphicCrossing.isClose(this.segment.getP1(), pending.segment.getP1()) || UGraphicCrossing.isClose(this.segment.getP1(), pending.segment.getP2()) || UGraphicCrossing.isClose(this.segment.getP2(), pending.segment.getP1()) || UGraphicCrossing.isClose(this.segment.getP2(), pending.segment.getP2()) || (point2D = this.segment.getSegIntersection(pending.segment)) == null) continue;
                arrayList.add(point2D);
            }
            return arrayList;
        }
    }
}

