/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import net.sourceforge.plantuml.ugraphic.USegmentType;

public class USegment {
    private final double[] coord;
    private final USegmentType pathType;

    public USegment(double[] dArray, USegmentType uSegmentType) {
        this.coord = (double[])dArray.clone();
        this.pathType = uSegmentType;
    }

    public String toString() {
        return this.pathType.toString() + " " + Arrays.toString(this.coord);
    }

    public final double[] getCoord() {
        return this.coord;
    }

    public final USegmentType getSegmentType() {
        return this.pathType;
    }

    public USegment translate(double d, double d2) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        Point2D.Double double_ = new Point2D.Double(this.coord[0] + d, this.coord[1] + d2);
        return new USegment(new double[]{((Point2D)double_).getX(), ((Point2D)double_).getY()}, this.pathType);
    }

    public USegment rotate(double d) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        Point2D.Double double_ = new Point2D.Double(this.coord[0], this.coord[1]);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
        affineTransform.transform(double_, double_);
        return new USegment(new double[]{((Point2D)double_).getX(), ((Point2D)double_).getY()}, this.pathType);
    }
}

