/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPolygon
extends AbstractShadowable {
    private final List<Point2D.Double> all = new ArrayList<Point2D.Double>();
    private final String name;
    private MinMax minmax = MinMax.getEmpty(false);

    public UPolygon() {
        this((String)null);
    }

    public UPolygon(List<Point2D.Double> list) {
        this((String)null);
        this.all.addAll(list);
        for (Point2D.Double double_ : this.all) {
            this.manageMinMax(double_.getX(), double_.getY());
        }
    }

    public UPolygon(String string) {
        this.name = string;
    }

    public Point2D checkMiddleContactForSpecificTriangle(Point2D point2D) {
        for (int i = 0; i < this.all.size() - 1; ++i) {
            Point2D.Double double_ = this.all.get(i);
            Point2D.Double double_2 = this.all.get(i + 1);
            Point2D.Double double_3 = new Point2D.Double((double_.getX() + double_2.getX()) / 2.0, (double_.getY() + double_2.getY()) / 2.0);
            double d = double_3.distance(point2D);
            if (!(d < 1.0)) continue;
            return this.all.get((i - 1) % this.all.size());
        }
        return null;
    }

    public void addPoint(double d, double d2) {
        this.all.add(new Point2D.Double(d, d2));
        this.manageMinMax(d, d2);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    private void manageMinMax(double d, double d2) {
        this.minmax = this.minmax.addPoint(d, d2);
    }

    public List<Point2D.Double> getPoints() {
        return this.all;
    }

    public UPolygon translate(double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        for (Point2D.Double double_ : this.all) {
            uPolygon.addPoint(double_.x + d, double_.y + d2);
        }
        return uPolygon;
    }

    public void rotate(double d) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
        for (Point2D.Double double_ : this.all) {
            affineTransform.transform(double_, double_);
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString() + " " + this.all;
    }

    public double getHeight() {
        return this.minmax.getHeight();
    }

    public double getWidth() {
        return this.minmax.getWidth();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public MinMax getMinMax() {
        return this.minmax;
    }

    public double[] getPointArray(double d, double d2) {
        double[] dArray = new double[this.getPoints().size() * 2];
        int n = 0;
        for (Point2D point2D : this.getPoints()) {
            dArray[n++] = point2D.getX() + d;
            dArray[n++] = point2D.getY() + d2;
        }
        return dArray;
    }
}

