/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UClip
implements UChange {
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public UClip(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public String toString() {
        return "CLIP x=" + this.x + " y=" + this.y + " w=" + this.width + " h=" + this.height;
    }

    public UClip translate(double d, double d2) {
        return new UClip(this.x + d, this.y + d2, this.width, this.height);
    }

    public UClip translate(UTranslate uTranslate) {
        return this.translate(uTranslate.getDx(), uTranslate.getDy());
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public boolean isInside(Point2D point2D) {
        return this.isInside(point2D.getX(), point2D.getY());
    }

    public boolean isInside(double d, double d2) {
        if (d < this.x) {
            assert (this.getClippedX(d) != d);
            return false;
        }
        if (d > this.x + this.width) {
            assert (this.getClippedX(d) != d);
            return false;
        }
        if (d2 < this.y) {
            assert (this.getClippedY(d2) != d2);
            return false;
        }
        if (d2 > this.y + this.height) {
            assert (this.getClippedY(d2) != d2);
            return false;
        }
        assert (this.getClippedX(d) == d);
        assert (this.getClippedY(d2) == d2);
        return true;
    }

    public Rectangle2D.Double getClippedRectangle(Rectangle2D.Double double_) {
        return (Rectangle2D.Double)double_.createIntersection(new Rectangle2D.Double(this.x, this.y, this.width, this.height));
    }

    public Line2D.Double getClippedLine(Line2D.Double double_) {
        if (this.isInside(double_.x1, double_.y1) && this.isInside(double_.x2, double_.y2)) {
            return double_;
        }
        if (!this.isInside(double_.x1, double_.y1) && !this.isInside(double_.x2, double_.y2)) {
            double d;
            double d2;
            if (double_.x1 == double_.x2 && (d2 = this.getClippedY(double_.y1)) != (d = this.getClippedY(double_.y2))) {
                return new Line2D.Double(double_.x1, d2, double_.x2, d);
            }
            return null;
        }
        if (double_.x1 != double_.x2 && double_.y1 != double_.y2) {
            return null;
        }
        assert (double_.x1 == double_.x2 || double_.y1 == double_.y2);
        if (double_.y1 == double_.y2) {
            double d = this.getClippedX(double_.x1);
            double d3 = this.getClippedX(double_.x2);
            return new Line2D.Double(d, double_.y1, d3, double_.y2);
        }
        if (double_.x1 == double_.x2) {
            double d = this.getClippedY(double_.y1);
            double d4 = this.getClippedY(double_.y2);
            return new Line2D.Double(double_.x1, d, double_.x2, d4);
        }
        throw new IllegalStateException();
    }

    private double getClippedX(double d) {
        if (d < this.x) {
            return this.x;
        }
        if (d > this.x + this.width) {
            return this.x + this.width;
        }
        return d;
    }

    private double getClippedY(double d) {
        if (d < this.y) {
            return this.y;
        }
        if (d > this.y + this.height) {
            return this.y + this.height;
        }
        return d;
    }

    public boolean isInside(double d, double d2, UPath uPath) {
        return this.isInside(d + uPath.getMinX(), d2 + uPath.getMinY()) && this.isInside(d + uPath.getMaxX(), d2 + uPath.getMaxY());
    }
}

