/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.SlotSet;
import net.sourceforge.plantuml.ugraphic.TextLimitFinder;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SlotFinder
implements UGraphic {
    private final SlotSet yslot;
    private final StringBounder stringBounder;
    private final UTranslate translate;

    public boolean matchesProperty(String string) {
        return false;
    }

    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new SlotFinder(this.stringBounder, this.yslot, this.translate.compose((UTranslate)uChange));
        }
        if (uChange instanceof UStroke) {
            return new SlotFinder(this);
        }
        if (uChange instanceof UChangeBackColor) {
            return new SlotFinder(this);
        }
        if (uChange instanceof UChangeColor) {
            return new SlotFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public SlotFinder(StringBounder stringBounder) {
        this(stringBounder, new SlotSet(), new UTranslate());
    }

    private SlotFinder(StringBounder stringBounder, SlotSet slotSet, UTranslate uTranslate) {
        this.stringBounder = stringBounder;
        this.yslot = slotSet;
        this.translate = uTranslate;
    }

    private SlotFinder(SlotFinder slotFinder) {
        this(slotFinder.stringBounder, slotFinder.yslot, slotFinder.translate);
    }

    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public UParam getParam() {
        return new UParamNull();
    }

    public void draw(UShape uShape) {
        double d = this.translate.getDx();
        double d2 = this.translate.getDy();
        if (uShape instanceof URectangle) {
            this.drawRectangle(d, d2, (URectangle)uShape);
        } else if (uShape instanceof UPolygon) {
            this.drawPolygon(d, d2, (UPolygon)uShape);
        } else if (uShape instanceof UEllipse) {
            this.drawEllipse(d, d2, (UEllipse)uShape);
        } else if (uShape instanceof UText) {
            this.drawText(d, d2, (UText)uShape);
        } else if (uShape instanceof UEmpty) {
            this.drawEmpty(d, d2, (UEmpty)uShape);
        }
    }

    private void drawEmpty(double d, double d2, UEmpty uEmpty) {
        this.yslot.addSlot(d2, d2 + uEmpty.getHeight());
    }

    private void drawText(double d, double d2, UText uText) {
        TextLimitFinder textLimitFinder = new TextLimitFinder(this.stringBounder, false);
        textLimitFinder.apply(new UTranslate(d, d2)).draw(uText);
        this.yslot.addSlot(textLimitFinder.getMinY(), textLimitFinder.getMaxY());
    }

    private void drawEllipse(double d, double d2, UEllipse uEllipse) {
        this.yslot.addSlot(d2, d2 + uEllipse.getHeight());
    }

    private void drawPolygon(double d, double d2, UPolygon uPolygon) {
        this.yslot.addSlot(d2 + uPolygon.getMinY(), d2 + uPolygon.getMaxY());
    }

    private void drawRectangle(double d, double d2, URectangle uRectangle) {
        this.yslot.addSlot(d2, d2 + uRectangle.getHeight());
    }

    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public SlotSet getYSlotSet() {
        return this.yslot;
    }

    public void flushUg() {
    }
}

